/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.SecurityAdminConfigurationPropertiesFormat;
import com.azure.resourcemanager.network.models.AddressSpaceAggregationOption;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.NetworkIntentPolicyBasedService;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class SecurityAdminConfigurationInner
extends ChildResource {
    private SecurityAdminConfigurationPropertiesFormat innerProperties;
    private SystemData systemData;
    private String etag;
    private String type;
    private String name;
    private String id;

    private SecurityAdminConfigurationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public SecurityAdminConfigurationInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityAdminConfigurationPropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public List<NetworkIntentPolicyBasedService> applyOnNetworkIntentPolicyBasedServices() {
        return this.innerProperties() == null ? null : this.innerProperties().applyOnNetworkIntentPolicyBasedServices();
    }

    public SecurityAdminConfigurationInner withApplyOnNetworkIntentPolicyBasedServices(List<NetworkIntentPolicyBasedService> applyOnNetworkIntentPolicyBasedServices) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityAdminConfigurationPropertiesFormat();
        }
        this.innerProperties().withApplyOnNetworkIntentPolicyBasedServices(applyOnNetworkIntentPolicyBasedServices);
        return this;
    }

    public AddressSpaceAggregationOption networkGroupAddressSpaceAggregationOption() {
        return this.innerProperties() == null ? null : this.innerProperties().networkGroupAddressSpaceAggregationOption();
    }

    public SecurityAdminConfigurationInner withNetworkGroupAddressSpaceAggregationOption(AddressSpaceAggregationOption networkGroupAddressSpaceAggregationOption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityAdminConfigurationPropertiesFormat();
        }
        this.innerProperties().withNetworkGroupAddressSpaceAggregationOption(networkGroupAddressSpaceAggregationOption);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SecurityAdminConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityAdminConfigurationInner)((Object)jsonReader.readObject(reader -> {
            SecurityAdminConfigurationInner deserializedSecurityAdminConfigurationInner = new SecurityAdminConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationInner.innerProperties = SecurityAdminConfigurationPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSecurityAdminConfigurationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityAdminConfigurationInner;
        }));
    }
}

