/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class PrivateLinkServiceIpConfigurationPropertiesInner
implements JsonSerializable<PrivateLinkServiceIpConfigurationPropertiesInner> {
    private String privateIpAddress;
    private IpAllocationMethod privateIpAllocationMethod;
    private SubnetInner subnet;
    private Boolean primary;
    private ProvisioningState provisioningState;
    private IpVersion privateIpAddressVersion;

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public PrivateLinkServiceIpConfigurationPropertiesInner withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public PrivateLinkServiceIpConfigurationPropertiesInner withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public SubnetInner subnet() {
        return this.subnet;
    }

    public PrivateLinkServiceIpConfigurationPropertiesInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    public Boolean primary() {
        return this.primary;
    }

    public PrivateLinkServiceIpConfigurationPropertiesInner withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public IpVersion privateIpAddressVersion() {
        return this.privateIpAddressVersion;
    }

    public PrivateLinkServiceIpConfigurationPropertiesInner withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        this.privateIpAddressVersion = privateIpAddressVersion;
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod", this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeBooleanField("primary", this.primary);
        jsonWriter.writeStringField("privateIPAddressVersion", this.privateIpAddressVersion == null ? null : this.privateIpAddressVersion.toString());
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkServiceIpConfigurationPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkServiceIpConfigurationPropertiesInner)jsonReader.readObject(reader -> {
            PrivateLinkServiceIpConfigurationPropertiesInner deserializedPrivateLinkServiceIpConfigurationPropertiesInner = new PrivateLinkServiceIpConfigurationPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateIPAddress".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.privateIpAddress = reader.getString();
                    continue;
                }
                if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.privateIpAllocationMethod = IpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.subnet = SubnetInner.fromJson(reader);
                    continue;
                }
                if ("primary".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.primary = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateIPAddressVersion".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.privateIpAddressVersion = IpVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkServiceIpConfigurationPropertiesInner;
        });
    }
}

