/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteLinkInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRoutePortPropertiesFormat;
import com.azure.resourcemanager.network.models.ExpressRoutePortsBillingType;
import com.azure.resourcemanager.network.models.ExpressRoutePortsEncapsulation;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExpressRoutePortInner
extends Resource {
    private ExpressRoutePortPropertiesFormat innerProperties;
    private String etag;
    private ManagedServiceIdentity identity;
    private String id;
    private String type;
    private String name;

    private ExpressRoutePortPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ExpressRoutePortInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String id() {
        return this.id;
    }

    public ExpressRoutePortInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public ExpressRoutePortInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExpressRoutePortInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String peeringLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringLocation();
    }

    public ExpressRoutePortInner withPeeringLocation(String peeringLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortPropertiesFormat();
        }
        this.innerProperties().withPeeringLocation(peeringLocation);
        return this;
    }

    public Integer bandwidthInGbps() {
        return this.innerProperties() == null ? null : this.innerProperties().bandwidthInGbps();
    }

    public ExpressRoutePortInner withBandwidthInGbps(Integer bandwidthInGbps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortPropertiesFormat();
        }
        this.innerProperties().withBandwidthInGbps(bandwidthInGbps);
        return this;
    }

    public Float provisionedBandwidthInGbps() {
        return this.innerProperties() == null ? null : this.innerProperties().provisionedBandwidthInGbps();
    }

    public String mtu() {
        return this.innerProperties() == null ? null : this.innerProperties().mtu();
    }

    public ExpressRoutePortsEncapsulation encapsulation() {
        return this.innerProperties() == null ? null : this.innerProperties().encapsulation();
    }

    public ExpressRoutePortInner withEncapsulation(ExpressRoutePortsEncapsulation encapsulation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortPropertiesFormat();
        }
        this.innerProperties().withEncapsulation(encapsulation);
        return this;
    }

    public String etherType() {
        return this.innerProperties() == null ? null : this.innerProperties().etherType();
    }

    public String allocationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().allocationDate();
    }

    public List<ExpressRouteLinkInner> links() {
        return this.innerProperties() == null ? null : this.innerProperties().links();
    }

    public ExpressRoutePortInner withLinks(List<ExpressRouteLinkInner> links) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortPropertiesFormat();
        }
        this.innerProperties().withLinks(links);
        return this;
    }

    public List<SubResource> circuits() {
        return this.innerProperties() == null ? null : this.innerProperties().circuits();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ExpressRoutePortsBillingType billingType() {
        return this.innerProperties() == null ? null : this.innerProperties().billingType();
    }

    public ExpressRoutePortInner withBillingType(ExpressRoutePortsBillingType billingType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortPropertiesFormat();
        }
        this.innerProperties().withBillingType(billingType);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRoutePortInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRoutePortInner)((Object)jsonReader.readObject(reader -> {
            ExpressRoutePortInner deserializedExpressRoutePortInner = new ExpressRoutePortInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExpressRoutePortInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRoutePortInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedExpressRoutePortInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExpressRoutePortInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRoutePortInner.innerProperties = ExpressRoutePortPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedExpressRoutePortInner.etag = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedExpressRoutePortInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedExpressRoutePortInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRoutePortInner;
        }));
    }
}

