/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.models.ProtocolType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.QosDefinition;
import com.azure.resourcemanager.network.models.QosIpRange;
import com.azure.resourcemanager.network.models.QosPortRange;
import java.io.IOException;
import java.util.List;

public final class DscpConfigurationPropertiesFormat
implements JsonSerializable<DscpConfigurationPropertiesFormat> {
    private List<Integer> markings;
    private List<QosIpRange> sourceIpRanges;
    private List<QosIpRange> destinationIpRanges;
    private List<QosPortRange> sourcePortRanges;
    private List<QosPortRange> destinationPortRanges;
    private ProtocolType protocol;
    private List<QosDefinition> qosDefinitionCollection;
    private String qosCollectionId;
    private List<NetworkInterfaceInner> associatedNetworkInterfaces;
    private String resourceGuid;
    private ProvisioningState provisioningState;

    public List<Integer> markings() {
        return this.markings;
    }

    public DscpConfigurationPropertiesFormat withMarkings(List<Integer> markings) {
        this.markings = markings;
        return this;
    }

    public List<QosIpRange> sourceIpRanges() {
        return this.sourceIpRanges;
    }

    public DscpConfigurationPropertiesFormat withSourceIpRanges(List<QosIpRange> sourceIpRanges) {
        this.sourceIpRanges = sourceIpRanges;
        return this;
    }

    public List<QosIpRange> destinationIpRanges() {
        return this.destinationIpRanges;
    }

    public DscpConfigurationPropertiesFormat withDestinationIpRanges(List<QosIpRange> destinationIpRanges) {
        this.destinationIpRanges = destinationIpRanges;
        return this;
    }

    public List<QosPortRange> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public DscpConfigurationPropertiesFormat withSourcePortRanges(List<QosPortRange> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<QosPortRange> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public DscpConfigurationPropertiesFormat withDestinationPortRanges(List<QosPortRange> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public ProtocolType protocol() {
        return this.protocol;
    }

    public DscpConfigurationPropertiesFormat withProtocol(ProtocolType protocol) {
        this.protocol = protocol;
        return this;
    }

    public List<QosDefinition> qosDefinitionCollection() {
        return this.qosDefinitionCollection;
    }

    public DscpConfigurationPropertiesFormat withQosDefinitionCollection(List<QosDefinition> qosDefinitionCollection) {
        this.qosDefinitionCollection = qosDefinitionCollection;
        return this;
    }

    public String qosCollectionId() {
        return this.qosCollectionId;
    }

    public List<NetworkInterfaceInner> associatedNetworkInterfaces() {
        return this.associatedNetworkInterfaces;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.sourceIpRanges() != null) {
            this.sourceIpRanges().forEach(e -> e.validate());
        }
        if (this.destinationIpRanges() != null) {
            this.destinationIpRanges().forEach(e -> e.validate());
        }
        if (this.sourcePortRanges() != null) {
            this.sourcePortRanges().forEach(e -> e.validate());
        }
        if (this.destinationPortRanges() != null) {
            this.destinationPortRanges().forEach(e -> e.validate());
        }
        if (this.qosDefinitionCollection() != null) {
            this.qosDefinitionCollection().forEach(e -> e.validate());
        }
        if (this.associatedNetworkInterfaces() != null) {
            this.associatedNetworkInterfaces().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("markings", this.markings, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeArrayField("sourceIpRanges", this.sourceIpRanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("destinationIpRanges", this.destinationIpRanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("destinationPortRanges", this.destinationPortRanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeArrayField("qosDefinitionCollection", this.qosDefinitionCollection, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DscpConfigurationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (DscpConfigurationPropertiesFormat)jsonReader.readObject(reader -> {
            DscpConfigurationPropertiesFormat deserializedDscpConfigurationPropertiesFormat = new DscpConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("markings".equals(fieldName)) {
                    List markings;
                    deserializedDscpConfigurationPropertiesFormat.markings = markings = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("sourceIpRanges".equals(fieldName)) {
                    List sourceIpRanges;
                    deserializedDscpConfigurationPropertiesFormat.sourceIpRanges = sourceIpRanges = reader.readArray(reader1 -> QosIpRange.fromJson(reader1));
                    continue;
                }
                if ("destinationIpRanges".equals(fieldName)) {
                    List destinationIpRanges;
                    deserializedDscpConfigurationPropertiesFormat.destinationIpRanges = destinationIpRanges = reader.readArray(reader1 -> QosIpRange.fromJson(reader1));
                    continue;
                }
                if ("sourcePortRanges".equals(fieldName)) {
                    List sourcePortRanges;
                    deserializedDscpConfigurationPropertiesFormat.sourcePortRanges = sourcePortRanges = reader.readArray(reader1 -> QosPortRange.fromJson(reader1));
                    continue;
                }
                if ("destinationPortRanges".equals(fieldName)) {
                    List destinationPortRanges;
                    deserializedDscpConfigurationPropertiesFormat.destinationPortRanges = destinationPortRanges = reader.readArray(reader1 -> QosPortRange.fromJson(reader1));
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedDscpConfigurationPropertiesFormat.protocol = ProtocolType.fromString(reader.getString());
                    continue;
                }
                if ("qosDefinitionCollection".equals(fieldName)) {
                    List qosDefinitionCollection;
                    deserializedDscpConfigurationPropertiesFormat.qosDefinitionCollection = qosDefinitionCollection = reader.readArray(reader1 -> QosDefinition.fromJson(reader1));
                    continue;
                }
                if ("qosCollectionId".equals(fieldName)) {
                    deserializedDscpConfigurationPropertiesFormat.qosCollectionId = reader.getString();
                    continue;
                }
                if ("associatedNetworkInterfaces".equals(fieldName)) {
                    List associatedNetworkInterfaces;
                    deserializedDscpConfigurationPropertiesFormat.associatedNetworkInterfaces = associatedNetworkInterfaces = reader.readArray(reader1 -> NetworkInterfaceInner.fromJson(reader1));
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedDscpConfigurationPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDscpConfigurationPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscpConfigurationPropertiesFormat;
        });
    }
}

