/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayNatRuleInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayPropertiesFormat;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.AdminState;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayAutoScaleConfiguration;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayPolicyGroup;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewaySku;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayType;
import com.azure.resourcemanager.network.models.VpnClientConfiguration;
import com.azure.resourcemanager.network.models.VpnGatewayGeneration;
import com.azure.resourcemanager.network.models.VpnType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class VirtualNetworkGatewayInner
extends Resource {
    @JsonProperty(value="properties", required=true)
    private VirtualNetworkGatewayPropertiesFormat innerProperties = new VirtualNetworkGatewayPropertiesFormat();
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkGatewayInner.class);

    private VirtualNetworkGatewayPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualNetworkGatewayInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualNetworkGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public VirtualNetworkGatewayAutoScaleConfiguration autoScaleConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().autoScaleConfiguration();
    }

    public VirtualNetworkGatewayInner withAutoScaleConfiguration(VirtualNetworkGatewayAutoScaleConfiguration autoScaleConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withAutoScaleConfiguration(autoScaleConfiguration);
        return this;
    }

    public List<VirtualNetworkGatewayIpConfigurationInner> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public VirtualNetworkGatewayInner withIpConfigurations(List<VirtualNetworkGatewayIpConfigurationInner> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public VirtualNetworkGatewayType gatewayType() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayType();
    }

    public VirtualNetworkGatewayInner withGatewayType(VirtualNetworkGatewayType gatewayType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withGatewayType(gatewayType);
        return this;
    }

    public VpnType vpnType() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnType();
    }

    public VirtualNetworkGatewayInner withVpnType(VpnType vpnType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withVpnType(vpnType);
        return this;
    }

    public VpnGatewayGeneration vpnGatewayGeneration() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnGatewayGeneration();
    }

    public VirtualNetworkGatewayInner withVpnGatewayGeneration(VpnGatewayGeneration vpnGatewayGeneration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withVpnGatewayGeneration(vpnGatewayGeneration);
        return this;
    }

    public Boolean enableBgp() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBgp();
    }

    public VirtualNetworkGatewayInner withEnableBgp(Boolean enableBgp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withEnableBgp(enableBgp);
        return this;
    }

    public Boolean enablePrivateIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePrivateIpAddress();
    }

    public VirtualNetworkGatewayInner withEnablePrivateIpAddress(Boolean enablePrivateIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withEnablePrivateIpAddress(enablePrivateIpAddress);
        return this;
    }

    public Boolean active() {
        return this.innerProperties() == null ? null : this.innerProperties().active();
    }

    public VirtualNetworkGatewayInner withActive(Boolean active) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withActive(active);
        return this;
    }

    public Boolean disableIpSecReplayProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().disableIpSecReplayProtection();
    }

    public VirtualNetworkGatewayInner withDisableIpSecReplayProtection(Boolean disableIpSecReplayProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withDisableIpSecReplayProtection(disableIpSecReplayProtection);
        return this;
    }

    public SubResource gatewayDefaultSite() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayDefaultSite();
    }

    public VirtualNetworkGatewayInner withGatewayDefaultSite(SubResource gatewayDefaultSite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withGatewayDefaultSite(gatewayDefaultSite);
        return this;
    }

    public VirtualNetworkGatewaySku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public VirtualNetworkGatewayInner withSku(VirtualNetworkGatewaySku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public VpnClientConfiguration vpnClientConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnClientConfiguration();
    }

    public VirtualNetworkGatewayInner withVpnClientConfiguration(VpnClientConfiguration vpnClientConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withVpnClientConfiguration(vpnClientConfiguration);
        return this;
    }

    public List<VirtualNetworkGatewayPolicyGroup> virtualNetworkGatewayPolicyGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkGatewayPolicyGroups();
    }

    public VirtualNetworkGatewayInner withVirtualNetworkGatewayPolicyGroups(List<VirtualNetworkGatewayPolicyGroup> virtualNetworkGatewayPolicyGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withVirtualNetworkGatewayPolicyGroups(virtualNetworkGatewayPolicyGroups);
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpSettings();
    }

    public VirtualNetworkGatewayInner withBgpSettings(BgpSettings bgpSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withBgpSettings(bgpSettings);
        return this;
    }

    public AddressSpace customRoutes() {
        return this.innerProperties() == null ? null : this.innerProperties().customRoutes();
    }

    public VirtualNetworkGatewayInner withCustomRoutes(AddressSpace customRoutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withCustomRoutes(customRoutes);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean enableDnsForwarding() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDnsForwarding();
    }

    public VirtualNetworkGatewayInner withEnableDnsForwarding(Boolean enableDnsForwarding) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withEnableDnsForwarding(enableDnsForwarding);
        return this;
    }

    public String inboundDnsForwardingEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundDnsForwardingEndpoint();
    }

    public String vNetExtendedLocationResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().vNetExtendedLocationResourceId();
    }

    public VirtualNetworkGatewayInner withVNetExtendedLocationResourceId(String vNetExtendedLocationResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withVNetExtendedLocationResourceId(vNetExtendedLocationResourceId);
        return this;
    }

    public List<VirtualNetworkGatewayNatRuleInner> natRules() {
        return this.innerProperties() == null ? null : this.innerProperties().natRules();
    }

    public VirtualNetworkGatewayInner withNatRules(List<VirtualNetworkGatewayNatRuleInner> natRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withNatRules(natRules);
        return this;
    }

    public Boolean enableBgpRouteTranslationForNat() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBgpRouteTranslationForNat();
    }

    public VirtualNetworkGatewayInner withEnableBgpRouteTranslationForNat(Boolean enableBgpRouteTranslationForNat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withEnableBgpRouteTranslationForNat(enableBgpRouteTranslationForNat);
        return this;
    }

    public Boolean allowVirtualWanTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowVirtualWanTraffic();
    }

    public VirtualNetworkGatewayInner withAllowVirtualWanTraffic(Boolean allowVirtualWanTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withAllowVirtualWanTraffic(allowVirtualWanTraffic);
        return this;
    }

    public Boolean allowRemoteVnetTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowRemoteVnetTraffic();
    }

    public VirtualNetworkGatewayInner withAllowRemoteVnetTraffic(Boolean allowRemoteVnetTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withAllowRemoteVnetTraffic(allowRemoteVnetTraffic);
        return this;
    }

    public AdminState adminState() {
        return this.innerProperties() == null ? null : this.innerProperties().adminState();
    }

    public VirtualNetworkGatewayInner withAdminState(AdminState adminState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPropertiesFormat();
        }
        this.innerProperties().withAdminState(adminState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model VirtualNetworkGatewayInner"));
        }
        this.innerProperties().validate();
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }
}

