/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.ScheduledQueryRuleProperties;
import com.azure.resourcemanager.monitor.models.Actions;
import com.azure.resourcemanager.monitor.models.AlertSeverity;
import com.azure.resourcemanager.monitor.models.ScheduledQueryRuleCriteria;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public final class ScheduledQueryRuleResourcePatch
implements JsonSerializable<ScheduledQueryRuleResourcePatch> {
    private Map<String, String> tags;
    private ScheduledQueryRuleProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public ScheduledQueryRuleResourcePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private ScheduledQueryRuleProperties innerProperties() {
        return this.innerProperties;
    }

    public String createdWithApiVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().createdWithApiVersion();
    }

    public Boolean isLegacyLogAnalyticsRule() {
        return this.innerProperties() == null ? null : this.innerProperties().isLegacyLogAnalyticsRule();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ScheduledQueryRuleResourcePatch withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public ScheduledQueryRuleResourcePatch withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public AlertSeverity severity() {
        return this.innerProperties() == null ? null : this.innerProperties().severity();
    }

    public ScheduledQueryRuleResourcePatch withSeverity(AlertSeverity severity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withSeverity(severity);
        return this;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public ScheduledQueryRuleResourcePatch withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public List<String> scopes() {
        return this.innerProperties() == null ? null : this.innerProperties().scopes();
    }

    public ScheduledQueryRuleResourcePatch withScopes(List<String> scopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withScopes(scopes);
        return this;
    }

    public Duration evaluationFrequency() {
        return this.innerProperties() == null ? null : this.innerProperties().evaluationFrequency();
    }

    public ScheduledQueryRuleResourcePatch withEvaluationFrequency(Duration evaluationFrequency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withEvaluationFrequency(evaluationFrequency);
        return this;
    }

    public Duration windowSize() {
        return this.innerProperties() == null ? null : this.innerProperties().windowSize();
    }

    public ScheduledQueryRuleResourcePatch withWindowSize(Duration windowSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withWindowSize(windowSize);
        return this;
    }

    public Duration overrideQueryTimeRange() {
        return this.innerProperties() == null ? null : this.innerProperties().overrideQueryTimeRange();
    }

    public ScheduledQueryRuleResourcePatch withOverrideQueryTimeRange(Duration overrideQueryTimeRange) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withOverrideQueryTimeRange(overrideQueryTimeRange);
        return this;
    }

    public List<String> targetResourceTypes() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceTypes();
    }

    public ScheduledQueryRuleResourcePatch withTargetResourceTypes(List<String> targetResourceTypes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withTargetResourceTypes(targetResourceTypes);
        return this;
    }

    public ScheduledQueryRuleCriteria criteria() {
        return this.innerProperties() == null ? null : this.innerProperties().criteria();
    }

    public ScheduledQueryRuleResourcePatch withCriteria(ScheduledQueryRuleCriteria criteria) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withCriteria(criteria);
        return this;
    }

    public Duration muteActionsDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().muteActionsDuration();
    }

    public ScheduledQueryRuleResourcePatch withMuteActionsDuration(Duration muteActionsDuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withMuteActionsDuration(muteActionsDuration);
        return this;
    }

    public Actions actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public ScheduledQueryRuleResourcePatch withActions(Actions actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withActions(actions);
        return this;
    }

    public Boolean isWorkspaceAlertsStorageConfigured() {
        return this.innerProperties() == null ? null : this.innerProperties().isWorkspaceAlertsStorageConfigured();
    }

    public Boolean checkWorkspaceAlertsStorageConfigured() {
        return this.innerProperties() == null ? null : this.innerProperties().checkWorkspaceAlertsStorageConfigured();
    }

    public ScheduledQueryRuleResourcePatch withCheckWorkspaceAlertsStorageConfigured(Boolean checkWorkspaceAlertsStorageConfigured) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withCheckWorkspaceAlertsStorageConfigured(checkWorkspaceAlertsStorageConfigured);
        return this;
    }

    public Boolean skipQueryValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().skipQueryValidation();
    }

    public ScheduledQueryRuleResourcePatch withSkipQueryValidation(Boolean skipQueryValidation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withSkipQueryValidation(skipQueryValidation);
        return this;
    }

    public Boolean autoMitigate() {
        return this.innerProperties() == null ? null : this.innerProperties().autoMitigate();
    }

    public ScheduledQueryRuleResourcePatch withAutoMitigate(Boolean autoMitigate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withAutoMitigate(autoMitigate);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ScheduledQueryRuleResourcePatch fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduledQueryRuleResourcePatch)jsonReader.readObject(reader -> {
            ScheduledQueryRuleResourcePatch deserializedScheduledQueryRuleResourcePatch = new ScheduledQueryRuleResourcePatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedScheduledQueryRuleResourcePatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedScheduledQueryRuleResourcePatch.innerProperties = ScheduledQueryRuleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduledQueryRuleResourcePatch;
        });
    }
}

