/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.AutoscaleProfileInner;
import com.azure.resourcemanager.monitor.models.AutoscaleNotification;
import com.azure.resourcemanager.monitor.models.PredictiveAutoscalePolicy;
import java.io.IOException;
import java.util.List;

public final class AutoscaleSetting
implements JsonSerializable<AutoscaleSetting> {
    private List<AutoscaleProfileInner> profiles;
    private List<AutoscaleNotification> notifications;
    private Boolean enabled;
    private PredictiveAutoscalePolicy predictiveAutoscalePolicy;
    private String name;
    private String targetResourceUri;
    private String targetResourceLocation;
    private static final ClientLogger LOGGER = new ClientLogger(AutoscaleSetting.class);

    public List<AutoscaleProfileInner> profiles() {
        return this.profiles;
    }

    public AutoscaleSetting withProfiles(List<AutoscaleProfileInner> profiles) {
        this.profiles = profiles;
        return this;
    }

    public List<AutoscaleNotification> notifications() {
        return this.notifications;
    }

    public AutoscaleSetting withNotifications(List<AutoscaleNotification> notifications) {
        this.notifications = notifications;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public AutoscaleSetting withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PredictiveAutoscalePolicy predictiveAutoscalePolicy() {
        return this.predictiveAutoscalePolicy;
    }

    public AutoscaleSetting withPredictiveAutoscalePolicy(PredictiveAutoscalePolicy predictiveAutoscalePolicy) {
        this.predictiveAutoscalePolicy = predictiveAutoscalePolicy;
        return this;
    }

    public String name() {
        return this.name;
    }

    public AutoscaleSetting withName(String name) {
        this.name = name;
        return this;
    }

    public String targetResourceUri() {
        return this.targetResourceUri;
    }

    public AutoscaleSetting withTargetResourceUri(String targetResourceUri) {
        this.targetResourceUri = targetResourceUri;
        return this;
    }

    public String targetResourceLocation() {
        return this.targetResourceLocation;
    }

    public AutoscaleSetting withTargetResourceLocation(String targetResourceLocation) {
        this.targetResourceLocation = targetResourceLocation;
        return this;
    }

    public void validate() {
        if (this.profiles() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property profiles in model AutoscaleSetting"));
        }
        this.profiles().forEach(e -> e.validate());
        if (this.notifications() != null) {
            this.notifications().forEach(e -> e.validate());
        }
        if (this.predictiveAutoscalePolicy() != null) {
            this.predictiveAutoscalePolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("profiles", this.profiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("notifications", this.notifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("predictiveAutoscalePolicy", (JsonSerializable)this.predictiveAutoscalePolicy);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("targetResourceUri", this.targetResourceUri);
        jsonWriter.writeStringField("targetResourceLocation", this.targetResourceLocation);
        return jsonWriter.writeEndObject();
    }

    public static AutoscaleSetting fromJson(JsonReader jsonReader) throws IOException {
        return (AutoscaleSetting)jsonReader.readObject(reader -> {
            AutoscaleSetting deserializedAutoscaleSetting = new AutoscaleSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("profiles".equals(fieldName)) {
                    List profiles;
                    deserializedAutoscaleSetting.profiles = profiles = reader.readArray(reader1 -> AutoscaleProfileInner.fromJson(reader1));
                    continue;
                }
                if ("notifications".equals(fieldName)) {
                    List notifications;
                    deserializedAutoscaleSetting.notifications = notifications = reader.readArray(reader1 -> AutoscaleNotification.fromJson(reader1));
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedAutoscaleSetting.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("predictiveAutoscalePolicy".equals(fieldName)) {
                    deserializedAutoscaleSetting.predictiveAutoscalePolicy = PredictiveAutoscalePolicy.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAutoscaleSetting.name = reader.getString();
                    continue;
                }
                if ("targetResourceUri".equals(fieldName)) {
                    deserializedAutoscaleSetting.targetResourceUri = reader.getString();
                    continue;
                }
                if ("targetResourceLocation".equals(fieldName)) {
                    deserializedAutoscaleSetting.targetResourceLocation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoscaleSetting;
        });
    }
}

