/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.OperationProperties;
import com.azure.resourcemanager.keyvault.models.OperationDisplay;
import com.azure.resourcemanager.keyvault.models.ServiceSpecification;
import java.io.IOException;

public final class OperationInner
implements JsonSerializable<OperationInner> {
    private String name;
    private OperationDisplay display;
    private String origin;
    private OperationProperties innerOperationProperties;
    private Boolean isDataAction;

    public String name() {
        return this.name;
    }

    public OperationInner withName(String name) {
        this.name = name;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public OperationInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    private OperationProperties innerOperationProperties() {
        return this.innerOperationProperties;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public ServiceSpecification serviceSpecification() {
        return this.innerOperationProperties() == null ? null : this.innerOperationProperties().serviceSpecification();
    }

    public OperationInner withServiceSpecification(ServiceSpecification serviceSpecification) {
        if (this.innerOperationProperties() == null) {
            this.innerOperationProperties = new OperationProperties();
        }
        this.innerOperationProperties().withServiceSpecification(serviceSpecification);
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.innerOperationProperties() != null) {
            this.innerOperationProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerOperationProperties);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        return jsonWriter.writeEndObject();
    }

    public static OperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationInner)jsonReader.readObject(reader -> {
            OperationInner deserializedOperationInner = new OperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationInner.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationInner.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationInner.origin = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationInner.innerOperationProperties = OperationProperties.fromJson(reader);
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationInner;
        });
    }
}

