/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateEndpointConnectionProperties;
import com.azure.resourcemanager.keyvault.models.ManagedHsmResource;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.azure.resourcemanager.keyvault.models.ManagedServiceIdentity;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateEndpoint;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateLinkServiceConnectionState;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointConnectionProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class MhsmPrivateEndpointConnectionInner
extends ManagedHsmResource {
    private MhsmPrivateEndpointConnectionProperties innerProperties;
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private MhsmPrivateEndpointConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public MhsmPrivateEndpointConnectionInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public MhsmPrivateEndpointConnectionInner withSku(ManagedHsmSku sku) {
        super.withSku(sku);
        return this;
    }

    @Override
    public MhsmPrivateEndpointConnectionInner withIdentity(ManagedServiceIdentity identity) {
        super.withIdentity(identity);
        return this;
    }

    @Override
    public MhsmPrivateEndpointConnectionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public MhsmPrivateEndpointConnectionInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public MhsmPrivateEndpoint privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    public MhsmPrivateEndpointConnectionInner withPrivateEndpoint(MhsmPrivateEndpoint privateEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MhsmPrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    public MhsmPrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    public MhsmPrivateEndpointConnectionInner withPrivateLinkServiceConnectionState(MhsmPrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MhsmPrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public MhsmPrivateEndpointConnectionInner withProvisioningState(PrivateEndpointConnectionProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MhsmPrivateEndpointConnectionProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static MhsmPrivateEndpointConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (MhsmPrivateEndpointConnectionInner)((Object)jsonReader.readObject(reader -> {
            MhsmPrivateEndpointConnectionInner deserializedMhsmPrivateEndpointConnectionInner = new MhsmPrivateEndpointConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMhsmPrivateEndpointConnectionInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.withSku(ManagedHsmSku.fromJson(reader));
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.withIdentity(ManagedServiceIdentity.fromJson(reader));
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.innerProperties = MhsmPrivateEndpointConnectionProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMhsmPrivateEndpointConnectionInner;
        }));
    }
}

