/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmInner;
import java.io.IOException;
import java.util.List;

public final class ManagedHsmListResult
implements JsonSerializable<ManagedHsmListResult> {
    private List<ManagedHsmInner> value;
    private String nextLink;

    public List<ManagedHsmInner> value() {
        return this.value;
    }

    public ManagedHsmListResult withValue(List<ManagedHsmInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ManagedHsmListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedHsmListResult)jsonReader.readObject(reader -> {
            ManagedHsmListResult deserializedManagedHsmListResult = new ManagedHsmListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedManagedHsmListResult.value = value = reader.readArray(reader1 -> ManagedHsmInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedManagedHsmListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmListResult;
        });
    }
}

