/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.fluent.models.EventhubInner;
import java.io.IOException;
import java.util.List;

public final class EventHubListResult
implements JsonSerializable<EventHubListResult> {
    private List<EventhubInner> value;
    private String nextLink;

    public List<EventhubInner> value() {
        return this.value;
    }

    public EventHubListResult withValue(List<EventhubInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public EventHubListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static EventHubListResult fromJson(JsonReader jsonReader) throws IOException {
        return (EventHubListResult)jsonReader.readObject(reader -> {
            EventHubListResult deserializedEventHubListResult = new EventHubListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedEventHubListResult.value = value = reader.readArray(reader1 -> EventhubInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedEventHubListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventHubListResult;
        });
    }
}

