/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.fluent.models.SchemaGroupProperties;
import com.azure.resourcemanager.eventhubs.models.SchemaCompatibility;
import com.azure.resourcemanager.eventhubs.models.SchemaType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class SchemaGroupInner
extends ProxyResource {
    private SchemaGroupProperties innerProperties;
    private SystemData systemData;
    private String location;
    private String id;
    private String name;
    private String type;

    private SchemaGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String location() {
        return this.location;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public OffsetDateTime updatedAtUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAtUtc();
    }

    public OffsetDateTime createdAtUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAtUtc();
    }

    public UUID etag() {
        return this.innerProperties() == null ? null : this.innerProperties().etag();
    }

    public Map<String, String> groupProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().groupProperties();
    }

    public SchemaGroupInner withGroupProperties(Map<String, String> groupProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SchemaGroupProperties();
        }
        this.innerProperties().withGroupProperties(groupProperties);
        return this;
    }

    public SchemaCompatibility schemaCompatibility() {
        return this.innerProperties() == null ? null : this.innerProperties().schemaCompatibility();
    }

    public SchemaGroupInner withSchemaCompatibility(SchemaCompatibility schemaCompatibility) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SchemaGroupProperties();
        }
        this.innerProperties().withSchemaCompatibility(schemaCompatibility);
        return this;
    }

    public SchemaType schemaType() {
        return this.innerProperties() == null ? null : this.innerProperties().schemaType();
    }

    public SchemaGroupInner withSchemaType(SchemaType schemaType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SchemaGroupProperties();
        }
        this.innerProperties().withSchemaType(schemaType);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SchemaGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (SchemaGroupInner)((Object)jsonReader.readObject(reader -> {
            SchemaGroupInner deserializedSchemaGroupInner = new SchemaGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSchemaGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSchemaGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSchemaGroupInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSchemaGroupInner.innerProperties = SchemaGroupProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSchemaGroupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSchemaGroupInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchemaGroupInner;
        }));
    }
}

