/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class DestinationProperties
implements JsonSerializable<DestinationProperties> {
    private String storageAccountResourceId;
    private String blobContainer;
    private String archiveNameFormat;
    private UUID dataLakeSubscriptionId;
    private String dataLakeAccountName;
    private String dataLakeFolderPath;

    public String storageAccountResourceId() {
        return this.storageAccountResourceId;
    }

    public DestinationProperties withStorageAccountResourceId(String storageAccountResourceId) {
        this.storageAccountResourceId = storageAccountResourceId;
        return this;
    }

    public String blobContainer() {
        return this.blobContainer;
    }

    public DestinationProperties withBlobContainer(String blobContainer) {
        this.blobContainer = blobContainer;
        return this;
    }

    public String archiveNameFormat() {
        return this.archiveNameFormat;
    }

    public DestinationProperties withArchiveNameFormat(String archiveNameFormat) {
        this.archiveNameFormat = archiveNameFormat;
        return this;
    }

    public UUID dataLakeSubscriptionId() {
        return this.dataLakeSubscriptionId;
    }

    public DestinationProperties withDataLakeSubscriptionId(UUID dataLakeSubscriptionId) {
        this.dataLakeSubscriptionId = dataLakeSubscriptionId;
        return this;
    }

    public String dataLakeAccountName() {
        return this.dataLakeAccountName;
    }

    public DestinationProperties withDataLakeAccountName(String dataLakeAccountName) {
        this.dataLakeAccountName = dataLakeAccountName;
        return this;
    }

    public String dataLakeFolderPath() {
        return this.dataLakeFolderPath;
    }

    public DestinationProperties withDataLakeFolderPath(String dataLakeFolderPath) {
        this.dataLakeFolderPath = dataLakeFolderPath;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountResourceId", this.storageAccountResourceId);
        jsonWriter.writeStringField("blobContainer", this.blobContainer);
        jsonWriter.writeStringField("archiveNameFormat", this.archiveNameFormat);
        jsonWriter.writeStringField("dataLakeSubscriptionId", Objects.toString(this.dataLakeSubscriptionId, null));
        jsonWriter.writeStringField("dataLakeAccountName", this.dataLakeAccountName);
        jsonWriter.writeStringField("dataLakeFolderPath", this.dataLakeFolderPath);
        return jsonWriter.writeEndObject();
    }

    public static DestinationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DestinationProperties)jsonReader.readObject(reader -> {
            DestinationProperties deserializedDestinationProperties = new DestinationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountResourceId".equals(fieldName)) {
                    deserializedDestinationProperties.storageAccountResourceId = reader.getString();
                    continue;
                }
                if ("blobContainer".equals(fieldName)) {
                    deserializedDestinationProperties.blobContainer = reader.getString();
                    continue;
                }
                if ("archiveNameFormat".equals(fieldName)) {
                    deserializedDestinationProperties.archiveNameFormat = reader.getString();
                    continue;
                }
                if ("dataLakeSubscriptionId".equals(fieldName)) {
                    deserializedDestinationProperties.dataLakeSubscriptionId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("dataLakeAccountName".equals(fieldName)) {
                    deserializedDestinationProperties.dataLakeAccountName = reader.getString();
                    continue;
                }
                if ("dataLakeFolderPath".equals(fieldName)) {
                    deserializedDestinationProperties.dataLakeFolderPath = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDestinationProperties;
        });
    }
}

