/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.resourcemanager.eventhubs.models.Sku;
import com.azure.resourcemanager.eventhubs.models.SkuName;
import com.azure.resourcemanager.eventhubs.models.SkuTier;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;

public class EventHubNamespaceSkuType
implements HasInnerModel<Sku> {
    public static final EventHubNamespaceSkuType BASIC = new EventHubNamespaceSkuType(new Sku().withName(SkuName.BASIC).withTier(SkuTier.BASIC));
    public static final EventHubNamespaceSkuType STANDARD = new EventHubNamespaceSkuType(new Sku().withName(SkuName.STANDARD).withTier(SkuTier.STANDARD));
    private final Sku sku;

    public EventHubNamespaceSkuType(Sku sku) {
        this.sku = sku;
    }

    public EventHubNamespaceSkuType(SkuName name, SkuTier tier) {
        this(new Sku().withName(name).withTier(tier).withCapacity(null));
    }

    public Sku innerModel() {
        return this.sku;
    }

    public SkuName name() {
        return this.sku.name();
    }

    public SkuTier tier() {
        return this.sku.tier();
    }

    public int capacity() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.sku.capacity());
    }

    public String toString() {
        return String.format("%s_%s", new Object[]{this.sku.name(), this.sku.tier()});
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EventHubNamespaceSkuType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        EventHubNamespaceSkuType rhs = (EventHubNamespaceSkuType)obj;
        if (this.sku == null) {
            return rhs.sku == null;
        }
        return this.toString().equalsIgnoreCase(rhs.toString());
    }
}

