/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.azure.resourcemanager.eventhubs.fluent.models.ConsumerGroupInner;
import com.azure.resourcemanager.eventhubs.implementation.Ancestors;
import com.azure.resourcemanager.eventhubs.implementation.NestedResourceImpl;
import com.azure.resourcemanager.eventhubs.models.EventHub;
import com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroup;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.time.OffsetDateTime;
import java.util.Objects;
import reactor.core.publisher.Mono;

class EventHubConsumerGroupImpl
extends NestedResourceImpl<EventHubConsumerGroup, ConsumerGroupInner, EventHubConsumerGroupImpl>
implements EventHubConsumerGroup,
EventHubConsumerGroup.Definition,
EventHubConsumerGroup.Update {
    private Ancestors.TwoAncestor ancestor;

    EventHubConsumerGroupImpl(String name, ConsumerGroupInner inner, EventHubsManager manager) {
        super(name, inner, manager);
        this.ancestor = new Ancestors().new Ancestors.TwoAncestor(inner.id());
    }

    EventHubConsumerGroupImpl(String name, EventHubsManager manager) {
        super(name, new ConsumerGroupInner(), manager);
    }

    @Override
    public String namespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String namespaceName() {
        return this.ancestor().ancestor2Name();
    }

    @Override
    public String eventHubName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((ConsumerGroupInner)((Object)this.innerModel())).createdAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((ConsumerGroupInner)((Object)this.innerModel())).updatedAt();
    }

    @Override
    public String userMetadata() {
        return ((ConsumerGroupInner)((Object)this.innerModel())).userMetadata();
    }

    @Override
    public EventHubConsumerGroupImpl withExistingEventHub(EventHub eventHub) {
        this.ancestor = new Ancestors().new Ancestors.TwoAncestor(this.selfId(eventHub.id()));
        return this;
    }

    @Override
    public EventHubConsumerGroupImpl withExistingEventHubId(String eventHubId) {
        this.ancestor = new Ancestors().new Ancestors.TwoAncestor(this.selfId(eventHubId));
        return this;
    }

    @Override
    public EventHubConsumerGroupImpl withExistingEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        this.ancestor = new Ancestors().new Ancestors.TwoAncestor(resourceGroupName, eventHubName, namespaceName);
        return this;
    }

    @Override
    public EventHubConsumerGroupImpl withUserMetadata(String metadata) {
        ((ConsumerGroupInner)((Object)this.innerModel())).withUserMetadata(metadata);
        return this;
    }

    public Mono<EventHubConsumerGroup> createResourceAsync() {
        return ((EventHubManagementClient)this.manager.serviceClient()).getConsumerGroups().createOrUpdateAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name(), ((ConsumerGroupInner)((Object)this.innerModel())).userMetadata()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<ConsumerGroupInner> getInnerAsync() {
        return ((EventHubManagementClient)this.manager.serviceClient()).getConsumerGroups().getAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name());
    }

    private Ancestors.TwoAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/consumerGroups/%s", parentId, this.name());
    }
}

