// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.models.MessagingRegionsProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Messaging Region. */
@Fluent
public final class MessagingRegionsInner extends Resource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MessagingRegionsInner.class);

    /*
     * Properties of Messaging Region
     */
    @JsonProperty(value = "properties")
    private MessagingRegionsProperties properties;

    /**
     * Get the properties property: Properties of Messaging Region.
     *
     * @return the properties value.
     */
    public MessagingRegionsProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of Messaging Region.
     *
     * @param properties the properties value to set.
     * @return the MessagingRegionsInner object itself.
     */
    public MessagingRegionsInner withProperties(MessagingRegionsProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
