// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Messaging Plan for the namespace. */
@JsonFlatten
@Immutable
public class MessagingPlanInner extends Resource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MessagingPlanInner.class);

    /*
     * Sku type
     */
    @JsonProperty(value = "properties.sku", access = JsonProperty.Access.WRITE_ONLY)
    private Integer sku;

    /*
     * Selected event hub unit
     */
    @JsonProperty(value = "properties.selectedEventHubUnit", access = JsonProperty.Access.WRITE_ONLY)
    private Integer selectedEventHubUnit;

    /*
     * The exact time the messaging plan was updated.
     */
    @JsonProperty(value = "properties.updatedAt", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;

    /*
     * revision number
     */
    @JsonProperty(value = "properties.revision", access = JsonProperty.Access.WRITE_ONLY)
    private Long revision;

    /**
     * Get the sku property: Sku type.
     *
     * @return the sku value.
     */
    public Integer sku() {
        return this.sku;
    }

    /**
     * Get the selectedEventHubUnit property: Selected event hub unit.
     *
     * @return the selectedEventHubUnit value.
     */
    public Integer selectedEventHubUnit() {
        return this.selectedEventHubUnit;
    }

    /**
     * Get the updatedAt property: The exact time the messaging plan was updated.
     *
     * @return the updatedAt value.
     */
    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    /**
     * Get the revision property: revision number.
     *
     * @return the revision value.
     */
    public Long revision() {
        return this.revision;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
