// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventhubs.fluent.models.MessagingRegionsInner;

/** An instance of this class provides access to all the operations defined in RegionsClient. */
public interface RegionsClient {
    /**
     * Gets the available Regions for a given sku.
     *
     * @param sku The sku type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the available Regions for a given sku.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MessagingRegionsInner> listBySkuAsync(String sku);

    /**
     * Gets the available Regions for a given sku.
     *
     * @param sku The sku type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the available Regions for a given sku.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MessagingRegionsInner> listBySku(String sku);

    /**
     * Gets the available Regions for a given sku.
     *
     * @param sku The sku type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the available Regions for a given sku.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MessagingRegionsInner> listBySku(String sku, Context context);
}
