/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.azure.resourcemanager.eventhubs.fluent.NamespacesClient;
import com.azure.resourcemanager.eventhubs.fluent.models.AuthorizationRuleInner;
import com.azure.resourcemanager.eventhubs.implementation.AuthorizationRulesBaseImpl;
import com.azure.resourcemanager.eventhubs.implementation.EventHubNamespaceAuthorizationRuleImpl;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespaceAuthorizationRule;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespaceAuthorizationRules;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class EventHubNamespaceAuthorizationRulesImpl
extends AuthorizationRulesBaseImpl<NamespacesClient, EventHubNamespaceAuthorizationRule, EventHubNamespaceAuthorizationRuleImpl>
implements EventHubNamespaceAuthorizationRules {
    public EventHubNamespaceAuthorizationRulesImpl(EventHubsManager manager) {
        super(manager, ((EventHubManagementClient)manager.serviceClient()).getNamespaces());
    }

    public EventHubNamespaceAuthorizationRuleImpl define(String name) {
        return new EventHubNamespaceAuthorizationRuleImpl(name, this.manager);
    }

    @Override
    public Mono<EventHubNamespaceAuthorizationRule> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public EventHubNamespaceAuthorizationRule getByName(String resourceGroupName, String namespaceName, String name) {
        return (EventHubNamespaceAuthorizationRule)this.getByNameAsync(resourceGroupName, namespaceName, name).block();
    }

    @Override
    public Mono<EventHubNamespaceAuthorizationRule> getByNameAsync(String resourceGroupName, String namespaceName, String name) {
        return ((NamespacesClient)this.innerModel()).getAuthorizationRuleAsync(resourceGroupName, namespaceName, name).map(this::wrapModel);
    }

    @Override
    public PagedIterable<EventHubNamespaceAuthorizationRule> listByNamespace(String resourceGroupName, String namespaceName) {
        return PagedConverter.mapPage(((NamespacesClient)this.innerModel()).listAuthorizationRules(resourceGroupName, namespaceName), this::wrapModel);
    }

    @Override
    public PagedFlux<EventHubNamespaceAuthorizationRule> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        return PagedConverter.mapPage(((NamespacesClient)this.innerModel()).listAuthorizationRulesAsync(resourceGroupName, namespaceName), this::wrapModel);
    }

    public Mono<Void> deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.deleteByNameAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Mono<Void> deleteByNameAsync(String resourceGroupName, String namespaceName, String name) {
        return ((NamespacesClient)this.innerModel()).deleteAuthorizationRuleAsync(resourceGroupName, namespaceName, name);
    }

    @Override
    public void deleteByName(String resourceGroupName, String namespaceName, String name) {
        this.deleteByNameAsync(resourceGroupName, namespaceName, name).block();
    }

    @Override
    protected EventHubNamespaceAuthorizationRuleImpl wrapModel(AuthorizationRuleInner innerModel) {
        return new EventHubNamespaceAuthorizationRuleImpl(innerModel.name(), innerModel, this.manager);
    }
}

