/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dns.models.ARecord;
import com.azure.resourcemanager.dns.models.AaaaRecord;
import com.azure.resourcemanager.dns.models.CaaRecord;
import com.azure.resourcemanager.dns.models.CnameRecord;
import com.azure.resourcemanager.dns.models.MxRecord;
import com.azure.resourcemanager.dns.models.NsRecord;
import com.azure.resourcemanager.dns.models.PtrRecord;
import com.azure.resourcemanager.dns.models.SoaRecord;
import com.azure.resourcemanager.dns.models.SrvRecord;
import com.azure.resourcemanager.dns.models.TxtRecord;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class RecordSetProperties
implements JsonSerializable<RecordSetProperties> {
    private Map<String, String> metadata;
    private Long ttl;
    private String fqdn;
    private String provisioningState;
    private SubResource targetResource;
    private List<ARecord> aRecords;
    private List<AaaaRecord> aaaaRecords;
    private List<MxRecord> mxRecords;
    private List<NsRecord> nsRecords;
    private List<PtrRecord> ptrRecords;
    private List<SrvRecord> srvRecords;
    private List<TxtRecord> txtRecords;
    private CnameRecord cnameRecord;
    private SoaRecord soaRecord;
    private List<CaaRecord> caaRecords;

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public RecordSetProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Long ttl() {
        return this.ttl;
    }

    public RecordSetProperties withTtl(Long ttl) {
        this.ttl = ttl;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public SubResource targetResource() {
        return this.targetResource;
    }

    public RecordSetProperties withTargetResource(SubResource targetResource) {
        this.targetResource = targetResource;
        return this;
    }

    public List<ARecord> aRecords() {
        return this.aRecords;
    }

    public RecordSetProperties withARecords(List<ARecord> aRecords) {
        this.aRecords = aRecords;
        return this;
    }

    public List<AaaaRecord> aaaaRecords() {
        return this.aaaaRecords;
    }

    public RecordSetProperties withAaaaRecords(List<AaaaRecord> aaaaRecords) {
        this.aaaaRecords = aaaaRecords;
        return this;
    }

    public List<MxRecord> mxRecords() {
        return this.mxRecords;
    }

    public RecordSetProperties withMxRecords(List<MxRecord> mxRecords) {
        this.mxRecords = mxRecords;
        return this;
    }

    public List<NsRecord> nsRecords() {
        return this.nsRecords;
    }

    public RecordSetProperties withNsRecords(List<NsRecord> nsRecords) {
        this.nsRecords = nsRecords;
        return this;
    }

    public List<PtrRecord> ptrRecords() {
        return this.ptrRecords;
    }

    public RecordSetProperties withPtrRecords(List<PtrRecord> ptrRecords) {
        this.ptrRecords = ptrRecords;
        return this;
    }

    public List<SrvRecord> srvRecords() {
        return this.srvRecords;
    }

    public RecordSetProperties withSrvRecords(List<SrvRecord> srvRecords) {
        this.srvRecords = srvRecords;
        return this;
    }

    public List<TxtRecord> txtRecords() {
        return this.txtRecords;
    }

    public RecordSetProperties withTxtRecords(List<TxtRecord> txtRecords) {
        this.txtRecords = txtRecords;
        return this;
    }

    public CnameRecord cnameRecord() {
        return this.cnameRecord;
    }

    public RecordSetProperties withCnameRecord(CnameRecord cnameRecord) {
        this.cnameRecord = cnameRecord;
        return this;
    }

    public SoaRecord soaRecord() {
        return this.soaRecord;
    }

    public RecordSetProperties withSoaRecord(SoaRecord soaRecord) {
        this.soaRecord = soaRecord;
        return this;
    }

    public List<CaaRecord> caaRecords() {
        return this.caaRecords;
    }

    public RecordSetProperties withCaaRecords(List<CaaRecord> caaRecords) {
        this.caaRecords = caaRecords;
        return this;
    }

    public void validate() {
        if (this.aRecords() != null) {
            this.aRecords().forEach(e -> e.validate());
        }
        if (this.aaaaRecords() != null) {
            this.aaaaRecords().forEach(e -> e.validate());
        }
        if (this.mxRecords() != null) {
            this.mxRecords().forEach(e -> e.validate());
        }
        if (this.nsRecords() != null) {
            this.nsRecords().forEach(e -> e.validate());
        }
        if (this.ptrRecords() != null) {
            this.ptrRecords().forEach(e -> e.validate());
        }
        if (this.srvRecords() != null) {
            this.srvRecords().forEach(e -> e.validate());
        }
        if (this.txtRecords() != null) {
            this.txtRecords().forEach(e -> e.validate());
        }
        if (this.cnameRecord() != null) {
            this.cnameRecord().validate();
        }
        if (this.soaRecord() != null) {
            this.soaRecord().validate();
        }
        if (this.caaRecords() != null) {
            this.caaRecords().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("TTL", (Number)this.ttl);
        jsonWriter.writeJsonField("targetResource", (JsonSerializable)this.targetResource);
        jsonWriter.writeArrayField("ARecords", this.aRecords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("AAAARecords", this.aaaaRecords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("MXRecords", this.mxRecords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("NSRecords", this.nsRecords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("PTRRecords", this.ptrRecords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("SRVRecords", this.srvRecords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("TXTRecords", this.txtRecords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("CNAMERecord", (JsonSerializable)this.cnameRecord);
        jsonWriter.writeJsonField("SOARecord", (JsonSerializable)this.soaRecord);
        jsonWriter.writeArrayField("caaRecords", this.caaRecords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RecordSetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RecordSetProperties)jsonReader.readObject(reader -> {
            RecordSetProperties deserializedRecordSetProperties = new RecordSetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedRecordSetProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("TTL".equals(fieldName)) {
                    deserializedRecordSetProperties.ttl = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedRecordSetProperties.fqdn = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRecordSetProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("targetResource".equals(fieldName)) {
                    deserializedRecordSetProperties.targetResource = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("ARecords".equals(fieldName)) {
                    List aRecords;
                    deserializedRecordSetProperties.aRecords = aRecords = reader.readArray(reader1 -> ARecord.fromJson(reader1));
                    continue;
                }
                if ("AAAARecords".equals(fieldName)) {
                    List aaaaRecords;
                    deserializedRecordSetProperties.aaaaRecords = aaaaRecords = reader.readArray(reader1 -> AaaaRecord.fromJson(reader1));
                    continue;
                }
                if ("MXRecords".equals(fieldName)) {
                    List mxRecords;
                    deserializedRecordSetProperties.mxRecords = mxRecords = reader.readArray(reader1 -> MxRecord.fromJson(reader1));
                    continue;
                }
                if ("NSRecords".equals(fieldName)) {
                    List nsRecords;
                    deserializedRecordSetProperties.nsRecords = nsRecords = reader.readArray(reader1 -> NsRecord.fromJson(reader1));
                    continue;
                }
                if ("PTRRecords".equals(fieldName)) {
                    List ptrRecords;
                    deserializedRecordSetProperties.ptrRecords = ptrRecords = reader.readArray(reader1 -> PtrRecord.fromJson(reader1));
                    continue;
                }
                if ("SRVRecords".equals(fieldName)) {
                    List srvRecords;
                    deserializedRecordSetProperties.srvRecords = srvRecords = reader.readArray(reader1 -> SrvRecord.fromJson(reader1));
                    continue;
                }
                if ("TXTRecords".equals(fieldName)) {
                    List txtRecords;
                    deserializedRecordSetProperties.txtRecords = txtRecords = reader.readArray(reader1 -> TxtRecord.fromJson(reader1));
                    continue;
                }
                if ("CNAMERecord".equals(fieldName)) {
                    deserializedRecordSetProperties.cnameRecord = CnameRecord.fromJson(reader);
                    continue;
                }
                if ("SOARecord".equals(fieldName)) {
                    deserializedRecordSetProperties.soaRecord = SoaRecord.fromJson(reader);
                    continue;
                }
                if ("caaRecords".equals(fieldName)) {
                    List caaRecords;
                    deserializedRecordSetProperties.caaRecords = caaRecords = reader.readArray(reader1 -> CaaRecord.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecordSetProperties;
        });
    }
}

