/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.WebAnonymousAuthentication;
import com.azure.resourcemanager.datafactory.models.WebAuthenticationType;
import com.azure.resourcemanager.datafactory.models.WebBasicAuthentication;
import com.azure.resourcemanager.datafactory.models.WebClientCertificateAuthentication;
import java.io.IOException;

public class WebLinkedServiceTypeProperties
implements JsonSerializable<WebLinkedServiceTypeProperties> {
    private WebAuthenticationType authenticationType = WebAuthenticationType.fromString("WebLinkedServiceTypeProperties");
    private Object url;
    private static final ClientLogger LOGGER = new ClientLogger(WebLinkedServiceTypeProperties.class);

    public WebAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public Object url() {
        return this.url;
    }

    public WebLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model WebLinkedServiceTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static WebLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                WebLinkedServiceTypeProperties webLinkedServiceTypeProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("authenticationType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Anonymous".equals(discriminatorValue)) {
                    webLinkedServiceTypeProperties = WebAnonymousAuthentication.fromJson(readerToUse.reset());
                    return webLinkedServiceTypeProperties;
                }
                if ("Basic".equals(discriminatorValue)) {
                    webLinkedServiceTypeProperties = WebBasicAuthentication.fromJson(readerToUse.reset());
                    return webLinkedServiceTypeProperties;
                }
                if ("ClientCertificate".equals(discriminatorValue)) {
                    webLinkedServiceTypeProperties = WebClientCertificateAuthentication.fromJson(readerToUse.reset());
                    return webLinkedServiceTypeProperties;
                }
                webLinkedServiceTypeProperties = WebLinkedServiceTypeProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return webLinkedServiceTypeProperties;
            }
        });
    }

    static WebLinkedServiceTypeProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (WebLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            WebLinkedServiceTypeProperties deserializedWebLinkedServiceTypeProperties = new WebLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedWebLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedWebLinkedServiceTypeProperties.authenticationType = WebAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebLinkedServiceTypeProperties;
        });
    }
}

