/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class WebActivityAuthentication
implements JsonSerializable<WebActivityAuthentication> {
    private String type;
    private SecretBase pfx;
    private Object username;
    private SecretBase password;
    private Object resource;
    private Object userTenant;
    private CredentialReference credential;

    public String type() {
        return this.type;
    }

    public WebActivityAuthentication withType(String type) {
        this.type = type;
        return this;
    }

    public SecretBase pfx() {
        return this.pfx;
    }

    public WebActivityAuthentication withPfx(SecretBase pfx) {
        this.pfx = pfx;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public WebActivityAuthentication withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public WebActivityAuthentication withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object resource() {
        return this.resource;
    }

    public WebActivityAuthentication withResource(Object resource) {
        this.resource = resource;
        return this;
    }

    public Object userTenant() {
        return this.userTenant;
    }

    public WebActivityAuthentication withUserTenant(Object userTenant) {
        this.userTenant = userTenant;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public WebActivityAuthentication withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.pfx() != null) {
            this.pfx().validate();
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("pfx", (JsonSerializable)this.pfx);
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.resource != null) {
            jsonWriter.writeUntypedField("resource", this.resource);
        }
        if (this.userTenant != null) {
            jsonWriter.writeUntypedField("userTenant", this.userTenant);
        }
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static WebActivityAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (WebActivityAuthentication)jsonReader.readObject(reader -> {
            WebActivityAuthentication deserializedWebActivityAuthentication = new WebActivityAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedWebActivityAuthentication.type = reader.getString();
                    continue;
                }
                if ("pfx".equals(fieldName)) {
                    deserializedWebActivityAuthentication.pfx = SecretBase.fromJson(reader);
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedWebActivityAuthentication.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedWebActivityAuthentication.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("resource".equals(fieldName)) {
                    deserializedWebActivityAuthentication.resource = reader.readUntyped();
                    continue;
                }
                if ("userTenant".equals(fieldName)) {
                    deserializedWebActivityAuthentication.userTenant = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedWebActivityAuthentication.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebActivityAuthentication;
        });
    }
}

