/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.VariableType;
import java.io.IOException;

public final class VariableSpecification
implements JsonSerializable<VariableSpecification> {
    private VariableType type;
    private Object defaultValue;
    private static final ClientLogger LOGGER = new ClientLogger(VariableSpecification.class);

    public VariableType type() {
        return this.type;
    }

    public VariableSpecification withType(VariableType type) {
        this.type = type;
        return this;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public VariableSpecification withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model VariableSpecification"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (this.defaultValue != null) {
            jsonWriter.writeUntypedField("defaultValue", this.defaultValue);
        }
        return jsonWriter.writeEndObject();
    }

    public static VariableSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (VariableSpecification)jsonReader.readObject(reader -> {
            VariableSpecification deserializedVariableSpecification = new VariableSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedVariableSpecification.type = VariableType.fromString(reader.getString());
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedVariableSpecification.defaultValue = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVariableSpecification;
        });
    }
}

