/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ValidationActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ValidationActivity
extends ControlActivity {
    private String type = "Validation";
    private ValidationActivityTypeProperties innerTypeProperties = new ValidationActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ValidationActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    ValidationActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ValidationActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ValidationActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ValidationActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public ValidationActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ValidationActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ValidationActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object timeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().timeout();
    }

    public ValidationActivity withTimeout(Object timeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withTimeout(timeout);
        return this;
    }

    public Object sleep() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sleep();
    }

    public ValidationActivity withSleep(Object sleep) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withSleep(sleep);
        return this;
    }

    public Object minimumSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().minimumSize();
    }

    public ValidationActivity withMinimumSize(Object minimumSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withMinimumSize(minimumSize);
        return this;
    }

    public Object childItems() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().childItems();
    }

    public ValidationActivity withChildItems(Object childItems) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withChildItems(childItems);
        return this;
    }

    public DatasetReference dataset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataset();
    }

    public ValidationActivity withDataset(DatasetReference dataset) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ValidationActivityTypeProperties();
        }
        this.innerTypeProperties().withDataset(dataset);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ValidationActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ValidationActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ValidationActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationActivity)jsonReader.readObject(reader -> {
            ValidationActivity deserializedValidationActivity = new ValidationActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedValidationActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedValidationActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedValidationActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedValidationActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedValidationActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedValidationActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedValidationActivity.innerTypeProperties = ValidationActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedValidationActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedValidationActivity.withAdditionalProperties(additionalProperties);
            return deserializedValidationActivity;
        });
    }
}

