/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.BlobEventsTrigger;
import com.azure.resourcemanager.datafactory.models.BlobTrigger;
import com.azure.resourcemanager.datafactory.models.ChainingTrigger;
import com.azure.resourcemanager.datafactory.models.CustomEventsTrigger;
import com.azure.resourcemanager.datafactory.models.MultiplePipelineTrigger;
import com.azure.resourcemanager.datafactory.models.RerunTumblingWindowTrigger;
import com.azure.resourcemanager.datafactory.models.ScheduleTrigger;
import com.azure.resourcemanager.datafactory.models.TriggerRuntimeState;
import com.azure.resourcemanager.datafactory.models.TumblingWindowTrigger;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Trigger
implements JsonSerializable<Trigger> {
    private String type = "Trigger";
    private String description;
    private TriggerRuntimeState runtimeState;
    private List<Object> annotations;
    private Map<String, Object> additionalProperties;

    public String type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public Trigger withDescription(String description) {
        this.description = description;
        return this;
    }

    public TriggerRuntimeState runtimeState() {
        return this.runtimeState;
    }

    Trigger withRuntimeState(TriggerRuntimeState runtimeState) {
        this.runtimeState = runtimeState;
        return this;
    }

    public List<Object> annotations() {
        return this.annotations;
    }

    public Trigger withAnnotations(List<Object> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public Trigger withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("annotations", this.annotations, (writer, element) -> writer.writeUntyped(element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Trigger fromJson(JsonReader jsonReader) throws IOException {
        return (Trigger)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Trigger trigger;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("MultiplePipelineTrigger".equals(discriminatorValue)) {
                    trigger = MultiplePipelineTrigger.fromJsonKnownDiscriminator(readerToUse.reset());
                    return trigger;
                }
                if ("ScheduleTrigger".equals(discriminatorValue)) {
                    trigger = ScheduleTrigger.fromJson(readerToUse.reset());
                    return trigger;
                }
                if ("BlobTrigger".equals(discriminatorValue)) {
                    trigger = BlobTrigger.fromJson(readerToUse.reset());
                    return trigger;
                }
                if ("BlobEventsTrigger".equals(discriminatorValue)) {
                    trigger = BlobEventsTrigger.fromJson(readerToUse.reset());
                    return trigger;
                }
                if ("CustomEventsTrigger".equals(discriminatorValue)) {
                    trigger = CustomEventsTrigger.fromJson(readerToUse.reset());
                    return trigger;
                }
                if ("TumblingWindowTrigger".equals(discriminatorValue)) {
                    trigger = TumblingWindowTrigger.fromJson(readerToUse.reset());
                    return trigger;
                }
                if ("RerunTumblingWindowTrigger".equals(discriminatorValue)) {
                    trigger = RerunTumblingWindowTrigger.fromJson(readerToUse.reset());
                    return trigger;
                }
                if ("ChainingTrigger".equals(discriminatorValue)) {
                    trigger = ChainingTrigger.fromJson(readerToUse.reset());
                    return trigger;
                }
                trigger = Trigger.fromJsonKnownDiscriminator(readerToUse.reset());
                return trigger;
            }
        });
    }

    static Trigger fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (Trigger)jsonReader.readObject(reader -> {
            Trigger deserializedTrigger = new Trigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedTrigger.type = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedTrigger.description = reader.getString();
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedTrigger.runtimeState = TriggerRuntimeState.fromString(reader.getString());
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations;
                    deserializedTrigger.annotations = annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTrigger.additionalProperties = additionalProperties;
            return deserializedTrigger;
        });
    }
}

