/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SynapseSparkJobActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.BigDataPoolParametrizationReference;
import com.azure.resourcemanager.datafactory.models.ConfigurationType;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.SparkConfigurationParametrizationReference;
import com.azure.resourcemanager.datafactory.models.SynapseSparkJobReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SynapseSparkJobDefinitionActivity
extends ExecutionActivity {
    private String type = "SparkJob";
    private SynapseSparkJobActivityTypeProperties innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SynapseSparkJobDefinitionActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    SynapseSparkJobActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SynapseSparkJobDefinitionActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SynapseSparkJobDefinitionActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public SynapseSparkJobReference sparkJob() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sparkJob();
    }

    public SynapseSparkJobDefinitionActivity withSparkJob(SynapseSparkJobReference sparkJob) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withSparkJob(sparkJob);
        return this;
    }

    public List<Object> arguments() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().arguments();
    }

    public SynapseSparkJobDefinitionActivity withArguments(List<Object> arguments) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withArguments(arguments);
        return this;
    }

    public Object file() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().file();
    }

    public SynapseSparkJobDefinitionActivity withFile(Object file) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withFile(file);
        return this;
    }

    public Object scanFolder() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scanFolder();
    }

    public SynapseSparkJobDefinitionActivity withScanFolder(Object scanFolder) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withScanFolder(scanFolder);
        return this;
    }

    public Object className() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().className();
    }

    public SynapseSparkJobDefinitionActivity withClassName(Object className) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withClassName(className);
        return this;
    }

    public List<Object> files() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().files();
    }

    public SynapseSparkJobDefinitionActivity withFiles(List<Object> files) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withFiles(files);
        return this;
    }

    public List<Object> pythonCodeReference() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pythonCodeReference();
    }

    public SynapseSparkJobDefinitionActivity withPythonCodeReference(List<Object> pythonCodeReference) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withPythonCodeReference(pythonCodeReference);
        return this;
    }

    public List<Object> filesV2() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().filesV2();
    }

    public SynapseSparkJobDefinitionActivity withFilesV2(List<Object> filesV2) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withFilesV2(filesV2);
        return this;
    }

    public BigDataPoolParametrizationReference targetBigDataPool() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().targetBigDataPool();
    }

    public SynapseSparkJobDefinitionActivity withTargetBigDataPool(BigDataPoolParametrizationReference targetBigDataPool) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withTargetBigDataPool(targetBigDataPool);
        return this;
    }

    public Object executorSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().executorSize();
    }

    public SynapseSparkJobDefinitionActivity withExecutorSize(Object executorSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withExecutorSize(executorSize);
        return this;
    }

    public Object conf() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().conf();
    }

    public SynapseSparkJobDefinitionActivity withConf(Object conf) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withConf(conf);
        return this;
    }

    public Object driverSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().driverSize();
    }

    public SynapseSparkJobDefinitionActivity withDriverSize(Object driverSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withDriverSize(driverSize);
        return this;
    }

    public Object numExecutors() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().numExecutors();
    }

    public SynapseSparkJobDefinitionActivity withNumExecutors(Object numExecutors) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withNumExecutors(numExecutors);
        return this;
    }

    public ConfigurationType configurationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().configurationType();
    }

    public SynapseSparkJobDefinitionActivity withConfigurationType(ConfigurationType configurationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withConfigurationType(configurationType);
        return this;
    }

    public SparkConfigurationParametrizationReference targetSparkConfiguration() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().targetSparkConfiguration();
    }

    public SynapseSparkJobDefinitionActivity withTargetSparkConfiguration(SparkConfigurationParametrizationReference targetSparkConfiguration) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withTargetSparkConfiguration(targetSparkConfiguration);
        return this;
    }

    public Map<String, Object> sparkConfig() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sparkConfig();
    }

    public SynapseSparkJobDefinitionActivity withSparkConfig(Map<String, Object> sparkConfig) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseSparkJobActivityTypeProperties();
        }
        this.innerTypeProperties().withSparkConfig(sparkConfig);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SynapseSparkJobDefinitionActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SynapseSparkJobDefinitionActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SynapseSparkJobDefinitionActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SynapseSparkJobDefinitionActivity)jsonReader.readObject(reader -> {
            SynapseSparkJobDefinitionActivity deserializedSynapseSparkJobDefinitionActivity = new SynapseSparkJobDefinitionActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSynapseSparkJobDefinitionActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSynapseSparkJobDefinitionActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.innerTypeProperties = SynapseSparkJobActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSynapseSparkJobDefinitionActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSynapseSparkJobDefinitionActivity.withAdditionalProperties(additionalProperties);
            return deserializedSynapseSparkJobDefinitionActivity;
        });
    }
}

