/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SsisLogLocationTypeProperties;
import com.azure.resourcemanager.datafactory.models.SsisAccessCredential;
import com.azure.resourcemanager.datafactory.models.SsisLogLocationType;
import java.io.IOException;

public final class SsisLogLocation
implements JsonSerializable<SsisLogLocation> {
    private Object logPath;
    private SsisLogLocationType type;
    private SsisLogLocationTypeProperties innerTypeProperties = new SsisLogLocationTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SsisLogLocation.class);

    public Object logPath() {
        return this.logPath;
    }

    public SsisLogLocation withLogPath(Object logPath) {
        this.logPath = logPath;
        return this;
    }

    public SsisLogLocationType type() {
        return this.type;
    }

    public SsisLogLocation withType(SsisLogLocationType type) {
        this.type = type;
        return this;
    }

    private SsisLogLocationTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public SsisAccessCredential accessCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accessCredential();
    }

    public SsisLogLocation withAccessCredential(SsisAccessCredential accessCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisLogLocationTypeProperties();
        }
        this.innerTypeProperties().withAccessCredential(accessCredential);
        return this;
    }

    public Object logRefreshInterval() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logRefreshInterval();
    }

    public SsisLogLocation withLogRefreshInterval(Object logRefreshInterval) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisLogLocationTypeProperties();
        }
        this.innerTypeProperties().withLogRefreshInterval(logRefreshInterval);
        return this;
    }

    public void validate() {
        if (this.logPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property logPath in model SsisLogLocation"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model SsisLogLocation"));
        }
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SsisLogLocation"));
        }
        this.innerTypeProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("logPath", this.logPath);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        return jsonWriter.writeEndObject();
    }

    public static SsisLogLocation fromJson(JsonReader jsonReader) throws IOException {
        return (SsisLogLocation)jsonReader.readObject(reader -> {
            SsisLogLocation deserializedSsisLogLocation = new SsisLogLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logPath".equals(fieldName)) {
                    deserializedSsisLogLocation.logPath = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSsisLogLocation.type = SsisLogLocationType.fromString(reader.getString());
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSsisLogLocation.innerTypeProperties = SsisLogLocationTypeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisLogLocation;
        });
    }
}

