/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.SqlUpsertSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SqlMISink
extends CopySink {
    private String type = "SqlMISink";
    private Object sqlWriterStoredProcedureName;
    private Object sqlWriterTableType;
    private Object preCopyScript;
    private Object storedProcedureParameters;
    private Object storedProcedureTableTypeParameterName;
    private Object tableOption;
    private Object sqlWriterUseTableLock;
    private Object writeBehavior;
    private SqlUpsertSettings upsertSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object sqlWriterStoredProcedureName() {
        return this.sqlWriterStoredProcedureName;
    }

    public SqlMISink withSqlWriterStoredProcedureName(Object sqlWriterStoredProcedureName) {
        this.sqlWriterStoredProcedureName = sqlWriterStoredProcedureName;
        return this;
    }

    public Object sqlWriterTableType() {
        return this.sqlWriterTableType;
    }

    public SqlMISink withSqlWriterTableType(Object sqlWriterTableType) {
        this.sqlWriterTableType = sqlWriterTableType;
        return this;
    }

    public Object preCopyScript() {
        return this.preCopyScript;
    }

    public SqlMISink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public Object storedProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public SqlMISink withStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    public Object storedProcedureTableTypeParameterName() {
        return this.storedProcedureTableTypeParameterName;
    }

    public SqlMISink withStoredProcedureTableTypeParameterName(Object storedProcedureTableTypeParameterName) {
        this.storedProcedureTableTypeParameterName = storedProcedureTableTypeParameterName;
        return this;
    }

    public Object tableOption() {
        return this.tableOption;
    }

    public SqlMISink withTableOption(Object tableOption) {
        this.tableOption = tableOption;
        return this;
    }

    public Object sqlWriterUseTableLock() {
        return this.sqlWriterUseTableLock;
    }

    public SqlMISink withSqlWriterUseTableLock(Object sqlWriterUseTableLock) {
        this.sqlWriterUseTableLock = sqlWriterUseTableLock;
        return this;
    }

    public Object writeBehavior() {
        return this.writeBehavior;
    }

    public SqlMISink withWriteBehavior(Object writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public SqlUpsertSettings upsertSettings() {
        return this.upsertSettings;
    }

    public SqlMISink withUpsertSettings(SqlUpsertSettings upsertSettings) {
        this.upsertSettings = upsertSettings;
        return this;
    }

    @Override
    public SqlMISink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SqlMISink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SqlMISink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SqlMISink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SqlMISink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SqlMISink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.upsertSettings() != null) {
            this.upsertSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.writeBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        }
        if (this.writeBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        }
        if (this.sinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        }
        if (this.sinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.sqlWriterStoredProcedureName != null) {
            jsonWriter.writeUntypedField("sqlWriterStoredProcedureName", this.sqlWriterStoredProcedureName);
        }
        if (this.sqlWriterTableType != null) {
            jsonWriter.writeUntypedField("sqlWriterTableType", this.sqlWriterTableType);
        }
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        if (this.storedProcedureParameters != null) {
            jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
        }
        if (this.storedProcedureTableTypeParameterName != null) {
            jsonWriter.writeUntypedField("storedProcedureTableTypeParameterName", this.storedProcedureTableTypeParameterName);
        }
        if (this.tableOption != null) {
            jsonWriter.writeUntypedField("tableOption", this.tableOption);
        }
        if (this.sqlWriterUseTableLock != null) {
            jsonWriter.writeUntypedField("sqlWriterUseTableLock", this.sqlWriterUseTableLock);
        }
        if (this.writeBehavior != null) {
            jsonWriter.writeUntypedField("writeBehavior", this.writeBehavior);
        }
        jsonWriter.writeJsonField("upsertSettings", (JsonSerializable)this.upsertSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlMISink fromJson(JsonReader jsonReader) throws IOException {
        return (SqlMISink)jsonReader.readObject(reader -> {
            SqlMISink deserializedSqlMISink = new SqlMISink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSqlMISink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSqlMISink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSqlMISink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSqlMISink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSqlMISink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSqlMISink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlMISink.type = reader.getString();
                    continue;
                }
                if ("sqlWriterStoredProcedureName".equals(fieldName)) {
                    deserializedSqlMISink.sqlWriterStoredProcedureName = reader.readUntyped();
                    continue;
                }
                if ("sqlWriterTableType".equals(fieldName)) {
                    deserializedSqlMISink.sqlWriterTableType = reader.readUntyped();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedSqlMISink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureParameters".equals(fieldName)) {
                    deserializedSqlMISink.storedProcedureParameters = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureTableTypeParameterName".equals(fieldName)) {
                    deserializedSqlMISink.storedProcedureTableTypeParameterName = reader.readUntyped();
                    continue;
                }
                if ("tableOption".equals(fieldName)) {
                    deserializedSqlMISink.tableOption = reader.readUntyped();
                    continue;
                }
                if ("sqlWriterUseTableLock".equals(fieldName)) {
                    deserializedSqlMISink.sqlWriterUseTableLock = reader.readUntyped();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedSqlMISink.writeBehavior = reader.readUntyped();
                    continue;
                }
                if ("upsertSettings".equals(fieldName)) {
                    deserializedSqlMISink.upsertSettings = SqlUpsertSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlMISink.withAdditionalProperties(additionalProperties);
            return deserializedSqlMISink;
        });
    }
}

