/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ScriptActivityParameter;
import java.io.IOException;
import java.util.List;

public final class ScriptActivityScriptBlock
implements JsonSerializable<ScriptActivityScriptBlock> {
    private Object text;
    private Object type;
    private List<ScriptActivityParameter> parameters;
    private static final ClientLogger LOGGER = new ClientLogger(ScriptActivityScriptBlock.class);

    public Object text() {
        return this.text;
    }

    public ScriptActivityScriptBlock withText(Object text) {
        this.text = text;
        return this;
    }

    public Object type() {
        return this.type;
    }

    public ScriptActivityScriptBlock withType(Object type) {
        this.type = type;
        return this;
    }

    public List<ScriptActivityParameter> parameters() {
        return this.parameters;
    }

    public ScriptActivityScriptBlock withParameters(List<ScriptActivityParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.text() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property text in model ScriptActivityScriptBlock"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ScriptActivityScriptBlock"));
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("text", this.text);
        jsonWriter.writeUntypedField("type", this.type);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ScriptActivityScriptBlock fromJson(JsonReader jsonReader) throws IOException {
        return (ScriptActivityScriptBlock)jsonReader.readObject(reader -> {
            ScriptActivityScriptBlock deserializedScriptActivityScriptBlock = new ScriptActivityScriptBlock();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedScriptActivityScriptBlock.text = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScriptActivityScriptBlock.type = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedScriptActivityScriptBlock.parameters = parameters = reader.readArray(reader1 -> ScriptActivityParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScriptActivityScriptBlock;
        });
    }
}

