/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ScriptActivityParameterDirection;
import com.azure.resourcemanager.datafactory.models.ScriptActivityParameterType;
import java.io.IOException;

public final class ScriptActivityParameter
implements JsonSerializable<ScriptActivityParameter> {
    private Object name;
    private ScriptActivityParameterType type;
    private Object value;
    private ScriptActivityParameterDirection direction;
    private Integer size;

    public Object name() {
        return this.name;
    }

    public ScriptActivityParameter withName(Object name) {
        this.name = name;
        return this;
    }

    public ScriptActivityParameterType type() {
        return this.type;
    }

    public ScriptActivityParameter withType(ScriptActivityParameterType type) {
        this.type = type;
        return this;
    }

    public Object value() {
        return this.value;
    }

    public ScriptActivityParameter withValue(Object value) {
        this.value = value;
        return this;
    }

    public ScriptActivityParameterDirection direction() {
        return this.direction;
    }

    public ScriptActivityParameter withDirection(ScriptActivityParameterDirection direction) {
        this.direction = direction;
        return this;
    }

    public Integer size() {
        return this.size;
    }

    public ScriptActivityParameter withSize(Integer size) {
        this.size = size;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.name != null) {
            jsonWriter.writeUntypedField("name", this.name);
        }
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (this.value != null) {
            jsonWriter.writeUntypedField("value", this.value);
        }
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeNumberField("size", (Number)this.size);
        return jsonWriter.writeEndObject();
    }

    public static ScriptActivityParameter fromJson(JsonReader jsonReader) throws IOException {
        return (ScriptActivityParameter)jsonReader.readObject(reader -> {
            ScriptActivityParameter deserializedScriptActivityParameter = new ScriptActivityParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedScriptActivityParameter.name = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScriptActivityParameter.type = ScriptActivityParameterType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedScriptActivityParameter.value = reader.readUntyped();
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedScriptActivityParameter.direction = ScriptActivityParameterDirection.fromString(reader.getString());
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedScriptActivityParameter.size = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScriptActivityParameter;
        });
    }
}

