/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ScheduleTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.MultiplePipelineTrigger;
import com.azure.resourcemanager.datafactory.models.ScheduleTriggerRecurrence;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.azure.resourcemanager.datafactory.models.TriggerRuntimeState;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ScheduleTrigger
extends MultiplePipelineTrigger {
    private String type = "ScheduleTrigger";
    private ScheduleTriggerTypeProperties innerTypeProperties = new ScheduleTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ScheduleTrigger.class);

    @Override
    public String type() {
        return this.type;
    }

    ScheduleTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ScheduleTrigger withPipelines(List<TriggerPipelineReference> pipelines) {
        super.withPipelines(pipelines);
        return this;
    }

    @Override
    public ScheduleTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ScheduleTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations((List)annotations);
        return this;
    }

    public ScheduleTriggerRecurrence recurrence() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().recurrence();
    }

    public ScheduleTrigger withRecurrence(ScheduleTriggerRecurrence recurrence) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ScheduleTriggerTypeProperties();
        }
        this.innerTypeProperties().withRecurrence(recurrence);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ScheduleTrigger"));
        }
        this.innerTypeProperties().validate();
        if (this.pipelines() != null) {
            this.pipelines().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("pipelines", this.pipelines(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ScheduleTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleTrigger)jsonReader.readObject(reader -> {
            ScheduleTrigger deserializedScheduleTrigger = new ScheduleTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedScheduleTrigger.withDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedScheduleTrigger.withRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedScheduleTrigger.withAnnotations(annotations);
                    continue;
                }
                if ("pipelines".equals(fieldName)) {
                    List pipelines = reader.readArray(reader1 -> TriggerPipelineReference.fromJson(reader1));
                    deserializedScheduleTrigger.withPipelines(pipelines);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedScheduleTrigger.innerTypeProperties = ScheduleTriggerTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScheduleTrigger.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedScheduleTrigger.withAdditionalProperties(additionalProperties);
            return deserializedScheduleTrigger;
        });
    }
}

