/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SalesforceV2Source
extends TabularSource {
    private String type = "SalesforceV2Source";
    private Object soqlQuery;
    private Object query;
    private Object includeDeletedObjects;
    private Object pageSize;

    @Override
    public String type() {
        return this.type;
    }

    public Object soqlQuery() {
        return this.soqlQuery;
    }

    public SalesforceV2Source withSoqlQuery(Object soqlQuery) {
        this.soqlQuery = soqlQuery;
        return this;
    }

    public Object query() {
        return this.query;
    }

    public SalesforceV2Source withQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object includeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    public SalesforceV2Source withIncludeDeletedObjects(Object includeDeletedObjects) {
        this.includeDeletedObjects = includeDeletedObjects;
        return this;
    }

    public Object pageSize() {
        return this.pageSize;
    }

    public SalesforceV2Source withPageSize(Object pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public SalesforceV2Source withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public SalesforceV2Source withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public SalesforceV2Source withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SalesforceV2Source withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SalesforceV2Source withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SalesforceV2Source withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        if (this.queryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        }
        if (this.additionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.soqlQuery != null) {
            jsonWriter.writeUntypedField("SOQLQuery", this.soqlQuery);
        }
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.includeDeletedObjects != null) {
            jsonWriter.writeUntypedField("includeDeletedObjects", this.includeDeletedObjects);
        }
        if (this.pageSize != null) {
            jsonWriter.writeUntypedField("pageSize", this.pageSize);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceV2Source fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceV2Source)jsonReader.readObject(reader -> {
            SalesforceV2Source deserializedSalesforceV2Source = new SalesforceV2Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSalesforceV2Source.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSalesforceV2Source.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSalesforceV2Source.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSalesforceV2Source.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedSalesforceV2Source.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSalesforceV2Source.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceV2Source.type = reader.getString();
                    continue;
                }
                if ("SOQLQuery".equals(fieldName)) {
                    deserializedSalesforceV2Source.soqlQuery = reader.readUntyped();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedSalesforceV2Source.query = reader.readUntyped();
                    continue;
                }
                if ("includeDeletedObjects".equals(fieldName)) {
                    deserializedSalesforceV2Source.includeDeletedObjects = reader.readUntyped();
                    continue;
                }
                if ("pageSize".equals(fieldName)) {
                    deserializedSalesforceV2Source.pageSize = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceV2Source.withAdditionalProperties(additionalProperties);
            return deserializedSalesforceV2Source;
        });
    }
}

