/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.RunQueryFilterOperand;
import com.azure.resourcemanager.datafactory.models.RunQueryFilterOperator;
import java.io.IOException;
import java.util.List;

public final class RunQueryFilter
implements JsonSerializable<RunQueryFilter> {
    private RunQueryFilterOperand operand;
    private RunQueryFilterOperator operator;
    private List<String> values;
    private static final ClientLogger LOGGER = new ClientLogger(RunQueryFilter.class);

    public RunQueryFilterOperand operand() {
        return this.operand;
    }

    public RunQueryFilter withOperand(RunQueryFilterOperand operand) {
        this.operand = operand;
        return this;
    }

    public RunQueryFilterOperator operator() {
        return this.operator;
    }

    public RunQueryFilter withOperator(RunQueryFilterOperator operator) {
        this.operator = operator;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public RunQueryFilter withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.operand() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operand in model RunQueryFilter"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model RunQueryFilter"));
        }
        if (this.values() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property values in model RunQueryFilter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operand", this.operand == null ? null : this.operand.toString());
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static RunQueryFilter fromJson(JsonReader jsonReader) throws IOException {
        return (RunQueryFilter)jsonReader.readObject(reader -> {
            RunQueryFilter deserializedRunQueryFilter = new RunQueryFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operand".equals(fieldName)) {
                    deserializedRunQueryFilter.operand = RunQueryFilterOperand.fromString(reader.getString());
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedRunQueryFilter.operator = RunQueryFilterOperator.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedRunQueryFilter.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunQueryFilter;
        });
    }
}

