/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.RunQueryFilter;
import com.azure.resourcemanager.datafactory.models.RunQueryOrderBy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class RunFilterParameters
implements JsonSerializable<RunFilterParameters> {
    private String continuationToken;
    private OffsetDateTime lastUpdatedAfter;
    private OffsetDateTime lastUpdatedBefore;
    private List<RunQueryFilter> filters;
    private List<RunQueryOrderBy> orderBy;
    private static final ClientLogger LOGGER = new ClientLogger(RunFilterParameters.class);

    public String continuationToken() {
        return this.continuationToken;
    }

    public RunFilterParameters withContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    public OffsetDateTime lastUpdatedAfter() {
        return this.lastUpdatedAfter;
    }

    public RunFilterParameters withLastUpdatedAfter(OffsetDateTime lastUpdatedAfter) {
        this.lastUpdatedAfter = lastUpdatedAfter;
        return this;
    }

    public OffsetDateTime lastUpdatedBefore() {
        return this.lastUpdatedBefore;
    }

    public RunFilterParameters withLastUpdatedBefore(OffsetDateTime lastUpdatedBefore) {
        this.lastUpdatedBefore = lastUpdatedBefore;
        return this;
    }

    public List<RunQueryFilter> filters() {
        return this.filters;
    }

    public RunFilterParameters withFilters(List<RunQueryFilter> filters) {
        this.filters = filters;
        return this;
    }

    public List<RunQueryOrderBy> orderBy() {
        return this.orderBy;
    }

    public RunFilterParameters withOrderBy(List<RunQueryOrderBy> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public void validate() {
        if (this.lastUpdatedAfter() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property lastUpdatedAfter in model RunFilterParameters"));
        }
        if (this.lastUpdatedBefore() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property lastUpdatedBefore in model RunFilterParameters"));
        }
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
        if (this.orderBy() != null) {
            this.orderBy().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastUpdatedAfter", this.lastUpdatedAfter == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedAfter));
        jsonWriter.writeStringField("lastUpdatedBefore", this.lastUpdatedBefore == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedBefore));
        jsonWriter.writeStringField("continuationToken", this.continuationToken);
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("orderBy", this.orderBy, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RunFilterParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RunFilterParameters)jsonReader.readObject(reader -> {
            RunFilterParameters deserializedRunFilterParameters = new RunFilterParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastUpdatedAfter".equals(fieldName)) {
                    deserializedRunFilterParameters.lastUpdatedAfter = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedBefore".equals(fieldName)) {
                    deserializedRunFilterParameters.lastUpdatedBefore = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("continuationToken".equals(fieldName)) {
                    deserializedRunFilterParameters.continuationToken = reader.getString();
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedRunFilterParameters.filters = filters = reader.readArray(reader1 -> RunQueryFilter.fromJson(reader1));
                    continue;
                }
                if ("orderBy".equals(fieldName)) {
                    List orderBy;
                    deserializedRunFilterParameters.orderBy = orderBy = reader.readArray(reader1 -> RunQueryOrderBy.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunFilterParameters;
        });
    }
}

