/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ArmIdWrapper;
import com.azure.resourcemanager.datafactory.models.PrivateLinkConnectionState;
import java.io.IOException;

public final class RemotePrivateEndpointConnection
implements JsonSerializable<RemotePrivateEndpointConnection> {
    private String provisioningState;
    private ArmIdWrapper privateEndpoint;
    private PrivateLinkConnectionState privateLinkServiceConnectionState;

    public String provisioningState() {
        return this.provisioningState;
    }

    public ArmIdWrapper privateEndpoint() {
        return this.privateEndpoint;
    }

    public RemotePrivateEndpointConnection withPrivateEndpoint(ArmIdWrapper privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public PrivateLinkConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public RemotePrivateEndpointConnection withPrivateLinkServiceConnectionState(PrivateLinkConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateEndpoint", (JsonSerializable)this.privateEndpoint);
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        return jsonWriter.writeEndObject();
    }

    public static RemotePrivateEndpointConnection fromJson(JsonReader jsonReader) throws IOException {
        return (RemotePrivateEndpointConnection)jsonReader.readObject(reader -> {
            RemotePrivateEndpointConnection deserializedRemotePrivateEndpointConnection = new RemotePrivateEndpointConnection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnection.provisioningState = reader.getString();
                    continue;
                }
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnection.privateEndpoint = ArmIdWrapper.fromJson(reader);
                    continue;
                }
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnection.privateLinkServiceConnectionState = PrivateLinkConnectionState.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRemotePrivateEndpointConnection;
        });
    }
}

