/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.PrivateEndpointConnectionResourceInner;
import java.io.IOException;
import java.util.List;

public final class PrivateEndpointConnectionListResponse
implements JsonSerializable<PrivateEndpointConnectionListResponse> {
    private List<PrivateEndpointConnectionResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionListResponse.class);

    public List<PrivateEndpointConnectionResourceInner> value() {
        return this.value;
    }

    public PrivateEndpointConnectionListResponse withValue(List<PrivateEndpointConnectionResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public PrivateEndpointConnectionListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model PrivateEndpointConnectionListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointConnectionListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointConnectionListResponse)jsonReader.readObject(reader -> {
            PrivateEndpointConnectionListResponse deserializedPrivateEndpointConnectionListResponse = new PrivateEndpointConnectionListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedPrivateEndpointConnectionListResponse.value = value = reader.readArray(reader1 -> PrivateEndpointConnectionResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointConnectionListResponse;
        });
    }
}

