/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DataFlowSource;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;

public final class PowerQuerySource
extends DataFlowSource {
    private String script;
    private static final ClientLogger LOGGER = new ClientLogger(PowerQuerySource.class);

    public String script() {
        return this.script;
    }

    public PowerQuerySource withScript(String script) {
        this.script = script;
        return this;
    }

    @Override
    public PowerQuerySource withSchemaLinkedService(LinkedServiceReference schemaLinkedService) {
        super.withSchemaLinkedService(schemaLinkedService);
        return this;
    }

    @Override
    public PowerQuerySource withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public PowerQuerySource withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public PowerQuerySource withDataset(DatasetReference dataset) {
        super.withDataset(dataset);
        return this;
    }

    @Override
    public PowerQuerySource withLinkedService(LinkedServiceReference linkedService) {
        super.withLinkedService(linkedService);
        return this;
    }

    @Override
    public PowerQuerySource withFlowlet(DataFlowReference flowlet) {
        super.withFlowlet(flowlet);
        return this;
    }

    @Override
    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model PowerQuerySource"));
        }
        if (this.dataset() != null) {
            this.dataset().validate();
        }
        if (this.linkedService() != null) {
            this.linkedService().validate();
        }
        if (this.flowlet() != null) {
            this.flowlet().validate();
        }
        if (this.schemaLinkedService() != null) {
            this.schemaLinkedService().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset());
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService());
        jsonWriter.writeJsonField("flowlet", (JsonSerializable)this.flowlet());
        jsonWriter.writeJsonField("schemaLinkedService", (JsonSerializable)this.schemaLinkedService());
        jsonWriter.writeStringField("script", this.script);
        return jsonWriter.writeEndObject();
    }

    public static PowerQuerySource fromJson(JsonReader jsonReader) throws IOException {
        return (PowerQuerySource)jsonReader.readObject(reader -> {
            PowerQuerySource deserializedPowerQuerySource = new PowerQuerySource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPowerQuerySource.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPowerQuerySource.withDescription(reader.getString());
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedPowerQuerySource.withDataset(DatasetReference.fromJson(reader));
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedPowerQuerySource.withLinkedService(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("flowlet".equals(fieldName)) {
                    deserializedPowerQuerySource.withFlowlet(DataFlowReference.fromJson(reader));
                    continue;
                }
                if ("schemaLinkedService".equals(fieldName)) {
                    deserializedPowerQuerySource.withSchemaLinkedService(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("script".equals(fieldName)) {
                    deserializedPowerQuerySource.script = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPowerQuerySource;
        });
    }
}

