/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.MappingDataFlowTypeProperties;
import com.azure.resourcemanager.datafactory.models.DataFlow;
import com.azure.resourcemanager.datafactory.models.DataFlowFolder;
import com.azure.resourcemanager.datafactory.models.DataFlowSink;
import com.azure.resourcemanager.datafactory.models.DataFlowSource;
import com.azure.resourcemanager.datafactory.models.Transformation;
import java.io.IOException;
import java.util.List;

public final class MappingDataFlow
extends DataFlow {
    private String type = "MappingDataFlow";
    private MappingDataFlowTypeProperties innerTypeProperties;

    @Override
    public String type() {
        return this.type;
    }

    MappingDataFlowTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public MappingDataFlow withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public MappingDataFlow withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public MappingDataFlow withFolder(DataFlowFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public List<DataFlowSource> sources() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sources();
    }

    public MappingDataFlow withSources(List<DataFlowSource> sources) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withSources(sources);
        return this;
    }

    public List<DataFlowSink> sinks() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sinks();
    }

    public MappingDataFlow withSinks(List<DataFlowSink> sinks) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withSinks(sinks);
        return this;
    }

    public List<Transformation> transformations() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().transformations();
    }

    public MappingDataFlow withTransformations(List<Transformation> transformations) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withTransformations(transformations);
        return this;
    }

    public String script() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().script();
    }

    public MappingDataFlow withScript(String script) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withScript(script);
        return this;
    }

    public List<String> scriptLines() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scriptLines();
    }

    public MappingDataFlow withScriptLines(List<String> scriptLines) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withScriptLines(scriptLines);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        return jsonWriter.writeEndObject();
    }

    public static MappingDataFlow fromJson(JsonReader jsonReader) throws IOException {
        return (MappingDataFlow)jsonReader.readObject(reader -> {
            MappingDataFlow deserializedMappingDataFlow = new MappingDataFlow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedMappingDataFlow.withDescription(reader.getString());
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMappingDataFlow.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedMappingDataFlow.withFolder(DataFlowFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMappingDataFlow.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedMappingDataFlow.innerTypeProperties = MappingDataFlowTypeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMappingDataFlow;
        });
    }
}

