/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedIdentityTypeProperties;
import com.azure.resourcemanager.datafactory.models.Credential;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ManagedIdentityCredential
extends Credential {
    private String type = "ManagedIdentity";
    private ManagedIdentityTypeProperties innerTypeProperties;

    @Override
    public String type() {
        return this.type;
    }

    ManagedIdentityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ManagedIdentityCredential withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ManagedIdentityCredential withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public String resourceId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().resourceId();
    }

    public ManagedIdentityCredential withResourceId(String resourceId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ManagedIdentityTypeProperties();
        }
        this.innerTypeProperties().withResourceId(resourceId);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ManagedIdentityCredential fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIdentityCredential)jsonReader.readObject(reader -> {
            ManagedIdentityCredential deserializedManagedIdentityCredential = new ManagedIdentityCredential();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedManagedIdentityCredential.withDescription(reader.getString());
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedManagedIdentityCredential.withAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedIdentityCredential.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedManagedIdentityCredential.innerTypeProperties = ManagedIdentityTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedManagedIdentityCredential.withAdditionalProperties(additionalProperties);
            return deserializedManagedIdentityCredential;
        });
    }
}

