/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.EntityReference;
import java.io.IOException;

public final class IntegrationRuntimeDataProxyProperties
implements JsonSerializable<IntegrationRuntimeDataProxyProperties> {
    private EntityReference connectVia;
    private EntityReference stagingLinkedService;
    private String path;

    public EntityReference connectVia() {
        return this.connectVia;
    }

    public IntegrationRuntimeDataProxyProperties withConnectVia(EntityReference connectVia) {
        this.connectVia = connectVia;
        return this;
    }

    public EntityReference stagingLinkedService() {
        return this.stagingLinkedService;
    }

    public IntegrationRuntimeDataProxyProperties withStagingLinkedService(EntityReference stagingLinkedService) {
        this.stagingLinkedService = stagingLinkedService;
        return this;
    }

    public String path() {
        return this.path;
    }

    public IntegrationRuntimeDataProxyProperties withPath(String path) {
        this.path = path;
        return this;
    }

    public void validate() {
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.stagingLinkedService() != null) {
            this.stagingLinkedService().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia);
        jsonWriter.writeJsonField("stagingLinkedService", (JsonSerializable)this.stagingLinkedService);
        jsonWriter.writeStringField("path", this.path);
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeDataProxyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeDataProxyProperties)jsonReader.readObject(reader -> {
            IntegrationRuntimeDataProxyProperties deserializedIntegrationRuntimeDataProxyProperties = new IntegrationRuntimeDataProxyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectVia".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataProxyProperties.connectVia = EntityReference.fromJson(reader);
                    continue;
                }
                if ("stagingLinkedService".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataProxyProperties.stagingLinkedService = EntityReference.fromJson(reader);
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedIntegrationRuntimeDataProxyProperties.path = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIntegrationRuntimeDataProxyProperties;
        });
    }
}

