/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopyComputeScaleProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeDataFlowProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeVNetProperties;
import com.azure.resourcemanager.datafactory.models.PipelineExternalComputeScaleProperties;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class IntegrationRuntimeComputeProperties
implements JsonSerializable<IntegrationRuntimeComputeProperties> {
    private String location;
    private String nodeSize;
    private Integer numberOfNodes;
    private Integer maxParallelExecutionsPerNode;
    private IntegrationRuntimeDataFlowProperties dataFlowProperties;
    private IntegrationRuntimeVNetProperties vNetProperties;
    private CopyComputeScaleProperties copyComputeScaleProperties;
    private PipelineExternalComputeScaleProperties pipelineExternalComputeScaleProperties;
    private Map<String, Object> additionalProperties;

    public String location() {
        return this.location;
    }

    public IntegrationRuntimeComputeProperties withLocation(String location) {
        this.location = location;
        return this;
    }

    public String nodeSize() {
        return this.nodeSize;
    }

    public IntegrationRuntimeComputeProperties withNodeSize(String nodeSize) {
        this.nodeSize = nodeSize;
        return this;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public IntegrationRuntimeComputeProperties withNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        return this;
    }

    public Integer maxParallelExecutionsPerNode() {
        return this.maxParallelExecutionsPerNode;
    }

    public IntegrationRuntimeComputeProperties withMaxParallelExecutionsPerNode(Integer maxParallelExecutionsPerNode) {
        this.maxParallelExecutionsPerNode = maxParallelExecutionsPerNode;
        return this;
    }

    public IntegrationRuntimeDataFlowProperties dataFlowProperties() {
        return this.dataFlowProperties;
    }

    public IntegrationRuntimeComputeProperties withDataFlowProperties(IntegrationRuntimeDataFlowProperties dataFlowProperties) {
        this.dataFlowProperties = dataFlowProperties;
        return this;
    }

    public IntegrationRuntimeVNetProperties vNetProperties() {
        return this.vNetProperties;
    }

    public IntegrationRuntimeComputeProperties withVNetProperties(IntegrationRuntimeVNetProperties vNetProperties) {
        this.vNetProperties = vNetProperties;
        return this;
    }

    public CopyComputeScaleProperties copyComputeScaleProperties() {
        return this.copyComputeScaleProperties;
    }

    public IntegrationRuntimeComputeProperties withCopyComputeScaleProperties(CopyComputeScaleProperties copyComputeScaleProperties) {
        this.copyComputeScaleProperties = copyComputeScaleProperties;
        return this;
    }

    public PipelineExternalComputeScaleProperties pipelineExternalComputeScaleProperties() {
        return this.pipelineExternalComputeScaleProperties;
    }

    public IntegrationRuntimeComputeProperties withPipelineExternalComputeScaleProperties(PipelineExternalComputeScaleProperties pipelineExternalComputeScaleProperties) {
        this.pipelineExternalComputeScaleProperties = pipelineExternalComputeScaleProperties;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public IntegrationRuntimeComputeProperties withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.dataFlowProperties() != null) {
            this.dataFlowProperties().validate();
        }
        if (this.vNetProperties() != null) {
            this.vNetProperties().validate();
        }
        if (this.copyComputeScaleProperties() != null) {
            this.copyComputeScaleProperties().validate();
        }
        if (this.pipelineExternalComputeScaleProperties() != null) {
            this.pipelineExternalComputeScaleProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeStringField("nodeSize", this.nodeSize);
        jsonWriter.writeNumberField("numberOfNodes", (Number)this.numberOfNodes);
        jsonWriter.writeNumberField("maxParallelExecutionsPerNode", (Number)this.maxParallelExecutionsPerNode);
        jsonWriter.writeJsonField("dataFlowProperties", (JsonSerializable)this.dataFlowProperties);
        jsonWriter.writeJsonField("vNetProperties", (JsonSerializable)this.vNetProperties);
        jsonWriter.writeJsonField("copyComputeScaleProperties", (JsonSerializable)this.copyComputeScaleProperties);
        jsonWriter.writeJsonField("pipelineExternalComputeScaleProperties", (JsonSerializable)this.pipelineExternalComputeScaleProperties);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeComputeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeComputeProperties)jsonReader.readObject(reader -> {
            IntegrationRuntimeComputeProperties deserializedIntegrationRuntimeComputeProperties = new IntegrationRuntimeComputeProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.location = reader.getString();
                    continue;
                }
                if ("nodeSize".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.nodeSize = reader.getString();
                    continue;
                }
                if ("numberOfNodes".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.numberOfNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxParallelExecutionsPerNode".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.maxParallelExecutionsPerNode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dataFlowProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.dataFlowProperties = IntegrationRuntimeDataFlowProperties.fromJson(reader);
                    continue;
                }
                if ("vNetProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.vNetProperties = IntegrationRuntimeVNetProperties.fromJson(reader);
                    continue;
                }
                if ("copyComputeScaleProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.copyComputeScaleProperties = CopyComputeScaleProperties.fromJson(reader);
                    continue;
                }
                if ("pipelineExternalComputeScaleProperties".equals(fieldName)) {
                    deserializedIntegrationRuntimeComputeProperties.pipelineExternalComputeScaleProperties = PipelineExternalComputeScaleProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIntegrationRuntimeComputeProperties.additionalProperties = additionalProperties;
            return deserializedIntegrationRuntimeComputeProperties;
        });
    }
}

