/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.HDInsightStreamingActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class HDInsightStreamingActivity
extends ExecutionActivity {
    private String type = "HDInsightStreaming";
    private HDInsightStreamingActivityTypeProperties innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightStreamingActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    HDInsightStreamingActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public HDInsightStreamingActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public HDInsightStreamingActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public List<LinkedServiceReference> storageLinkedServices() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storageLinkedServices();
    }

    public HDInsightStreamingActivity withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withStorageLinkedServices(storageLinkedServices);
        return this;
    }

    public List<Object> arguments() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().arguments();
    }

    public HDInsightStreamingActivity withArguments(List<Object> arguments) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withArguments(arguments);
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().getDebugInfo();
    }

    public HDInsightStreamingActivity withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withGetDebugInfo(getDebugInfo);
        return this;
    }

    public Object mapper() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mapper();
    }

    public HDInsightStreamingActivity withMapper(Object mapper) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withMapper(mapper);
        return this;
    }

    public Object reducer() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().reducer();
    }

    public HDInsightStreamingActivity withReducer(Object reducer) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withReducer(reducer);
        return this;
    }

    public Object input() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().input();
    }

    public HDInsightStreamingActivity withInput(Object input) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withInput(input);
        return this;
    }

    public Object output() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().output();
    }

    public HDInsightStreamingActivity withOutput(Object output) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withOutput(output);
        return this;
    }

    public List<Object> filePaths() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().filePaths();
    }

    public HDInsightStreamingActivity withFilePaths(List<Object> filePaths) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withFilePaths(filePaths);
        return this;
    }

    public LinkedServiceReference fileLinkedService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fileLinkedService();
    }

    public HDInsightStreamingActivity withFileLinkedService(LinkedServiceReference fileLinkedService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withFileLinkedService(fileLinkedService);
        return this;
    }

    public Object combiner() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().combiner();
    }

    public HDInsightStreamingActivity withCombiner(Object combiner) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withCombiner(combiner);
        return this;
    }

    public List<Object> commandEnvironment() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandEnvironment();
    }

    public HDInsightStreamingActivity withCommandEnvironment(List<Object> commandEnvironment) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withCommandEnvironment(commandEnvironment);
        return this;
    }

    public Map<String, Object> defines() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().defines();
    }

    public HDInsightStreamingActivity withDefines(Map<String, Object> defines) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightStreamingActivityTypeProperties();
        }
        this.innerTypeProperties().withDefines(defines);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model HDInsightStreamingActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model HDInsightStreamingActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HDInsightStreamingActivity fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightStreamingActivity)jsonReader.readObject(reader -> {
            HDInsightStreamingActivity deserializedHDInsightStreamingActivity = new HDInsightStreamingActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedHDInsightStreamingActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedHDInsightStreamingActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.innerTypeProperties = HDInsightStreamingActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHDInsightStreamingActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHDInsightStreamingActivity.withAdditionalProperties(additionalProperties);
            return deserializedHDInsightStreamingActivity;
        });
    }
}

