/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.GlobalParameterResourceInner;
import java.io.IOException;
import java.util.List;

public final class GlobalParameterListResponse
implements JsonSerializable<GlobalParameterListResponse> {
    private List<GlobalParameterResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(GlobalParameterListResponse.class);

    public List<GlobalParameterResourceInner> value() {
        return this.value;
    }

    public GlobalParameterListResponse withValue(List<GlobalParameterResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public GlobalParameterListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model GlobalParameterListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static GlobalParameterListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (GlobalParameterListResponse)jsonReader.readObject(reader -> {
            GlobalParameterListResponse deserializedGlobalParameterListResponse = new GlobalParameterListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedGlobalParameterListResponse.value = value = reader.readArray(reader1 -> GlobalParameterResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedGlobalParameterListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGlobalParameterListResponse;
        });
    }
}

