/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import com.azure.resourcemanager.datafactory.models.GitHubClientSecret;
import java.io.IOException;

public final class FactoryGitHubConfiguration
extends FactoryRepoConfiguration {
    private String type = "FactoryGitHubConfiguration";
    private String hostname;
    private String clientId;
    private GitHubClientSecret clientSecret;
    private static final ClientLogger LOGGER = new ClientLogger(FactoryGitHubConfiguration.class);

    @Override
    public String type() {
        return this.type;
    }

    public String hostname() {
        return this.hostname;
    }

    public FactoryGitHubConfiguration withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String clientId() {
        return this.clientId;
    }

    public FactoryGitHubConfiguration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public GitHubClientSecret clientSecret() {
        return this.clientSecret;
    }

    public FactoryGitHubConfiguration withClientSecret(GitHubClientSecret clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Override
    public FactoryGitHubConfiguration withAccountName(String accountName) {
        super.withAccountName(accountName);
        return this;
    }

    @Override
    public FactoryGitHubConfiguration withRepositoryName(String repositoryName) {
        super.withRepositoryName(repositoryName);
        return this;
    }

    @Override
    public FactoryGitHubConfiguration withCollaborationBranch(String collaborationBranch) {
        super.withCollaborationBranch(collaborationBranch);
        return this;
    }

    @Override
    public FactoryGitHubConfiguration withRootFolder(String rootFolder) {
        super.withRootFolder(rootFolder);
        return this;
    }

    @Override
    public FactoryGitHubConfiguration withLastCommitId(String lastCommitId) {
        super.withLastCommitId(lastCommitId);
        return this;
    }

    @Override
    public FactoryGitHubConfiguration withDisablePublish(Boolean disablePublish) {
        super.withDisablePublish(disablePublish);
        return this;
    }

    @Override
    public void validate() {
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
        if (this.accountName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountName in model FactoryGitHubConfiguration"));
        }
        if (this.repositoryName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property repositoryName in model FactoryGitHubConfiguration"));
        }
        if (this.collaborationBranch() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property collaborationBranch in model FactoryGitHubConfiguration"));
        }
        if (this.rootFolder() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rootFolder in model FactoryGitHubConfiguration"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName());
        jsonWriter.writeStringField("repositoryName", this.repositoryName());
        jsonWriter.writeStringField("collaborationBranch", this.collaborationBranch());
        jsonWriter.writeStringField("rootFolder", this.rootFolder());
        jsonWriter.writeStringField("lastCommitId", this.lastCommitId());
        jsonWriter.writeBooleanField("disablePublish", this.disablePublish());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        return jsonWriter.writeEndObject();
    }

    public static FactoryGitHubConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (FactoryGitHubConfiguration)jsonReader.readObject(reader -> {
            FactoryGitHubConfiguration deserializedFactoryGitHubConfiguration = new FactoryGitHubConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.withAccountName(reader.getString());
                    continue;
                }
                if ("repositoryName".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.withRepositoryName(reader.getString());
                    continue;
                }
                if ("collaborationBranch".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.withCollaborationBranch(reader.getString());
                    continue;
                }
                if ("rootFolder".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.withRootFolder(reader.getString());
                    continue;
                }
                if ("lastCommitId".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.withLastCommitId(reader.getString());
                    continue;
                }
                if ("disablePublish".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.withDisablePublish((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.type = reader.getString();
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.hostname = reader.getString();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.clientId = reader.getString();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedFactoryGitHubConfiguration.clientSecret = GitHubClientSecret.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFactoryGitHubConfiguration;
        });
    }
}

