/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CompressionReadSettings;
import com.azure.resourcemanager.datafactory.models.FormatReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DelimitedTextReadSettings
extends FormatReadSettings {
    private String type = "DelimitedTextReadSettings";
    private Object skipLineCount;
    private CompressionReadSettings compressionProperties;

    @Override
    public String type() {
        return this.type;
    }

    public Object skipLineCount() {
        return this.skipLineCount;
    }

    public DelimitedTextReadSettings withSkipLineCount(Object skipLineCount) {
        this.skipLineCount = skipLineCount;
        return this;
    }

    public CompressionReadSettings compressionProperties() {
        return this.compressionProperties;
    }

    public DelimitedTextReadSettings withCompressionProperties(CompressionReadSettings compressionProperties) {
        this.compressionProperties = compressionProperties;
        return this;
    }

    @Override
    public void validate() {
        if (this.compressionProperties() != null) {
            this.compressionProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.skipLineCount != null) {
            jsonWriter.writeUntypedField("skipLineCount", this.skipLineCount);
        }
        jsonWriter.writeJsonField("compressionProperties", (JsonSerializable)this.compressionProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DelimitedTextReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (DelimitedTextReadSettings)jsonReader.readObject(reader -> {
            DelimitedTextReadSettings deserializedDelimitedTextReadSettings = new DelimitedTextReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDelimitedTextReadSettings.type = reader.getString();
                    continue;
                }
                if ("skipLineCount".equals(fieldName)) {
                    deserializedDelimitedTextReadSettings.skipLineCount = reader.readUntyped();
                    continue;
                }
                if ("compressionProperties".equals(fieldName)) {
                    deserializedDelimitedTextReadSettings.compressionProperties = CompressionReadSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDelimitedTextReadSettings.withAdditionalProperties(additionalProperties);
            return deserializedDelimitedTextReadSettings;
        });
    }
}

