/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class DatasetReference
implements JsonSerializable<DatasetReference> {
    private final String type = "DatasetReference";
    private String referenceName;
    private Map<String, Object> parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DatasetReference.class);

    public String type() {
        return this.type;
    }

    public String referenceName() {
        return this.referenceName;
    }

    public DatasetReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public DatasetReference withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.referenceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model DatasetReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("referenceName", this.referenceName);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static DatasetReference fromJson(JsonReader jsonReader) throws IOException {
        return (DatasetReference)jsonReader.readObject(reader -> {
            DatasetReference deserializedDatasetReference = new DatasetReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("referenceName".equals(fieldName)) {
                    deserializedDatasetReference.referenceName = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDatasetReference.parameters = parameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatasetReference;
        });
    }
}

