/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlow;
import com.azure.resourcemanager.datafactory.models.SubResourceDebugResource;
import java.io.IOException;

public final class DataFlowDebugResource
extends SubResourceDebugResource {
    private DataFlow properties;
    private static final ClientLogger LOGGER = new ClientLogger(DataFlowDebugResource.class);

    public DataFlow properties() {
        return this.properties;
    }

    public DataFlowDebugResource withProperties(DataFlow properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public DataFlowDebugResource withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model DataFlowDebugResource"));
        }
        this.properties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowDebugResource fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowDebugResource)jsonReader.readObject(reader -> {
            DataFlowDebugResource deserializedDataFlowDebugResource = new DataFlowDebugResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDataFlowDebugResource.withName(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDataFlowDebugResource.properties = DataFlow.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowDebugResource;
        });
    }
}

