/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.CustomActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.CustomActivityReferenceObject;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CustomActivity
extends ExecutionActivity {
    private String type = "Custom";
    private CustomActivityTypeProperties innerTypeProperties = new CustomActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(CustomActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    CustomActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public CustomActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public CustomActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public CustomActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public CustomActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public CustomActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public CustomActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public CustomActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public CustomActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object command() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().command();
    }

    public CustomActivity withCommand(Object command) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withCommand(command);
        return this;
    }

    public LinkedServiceReference resourceLinkedService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().resourceLinkedService();
    }

    public CustomActivity withResourceLinkedService(LinkedServiceReference resourceLinkedService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withResourceLinkedService(resourceLinkedService);
        return this;
    }

    public Object folderPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().folderPath();
    }

    public CustomActivity withFolderPath(Object folderPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withFolderPath(folderPath);
        return this;
    }

    public CustomActivityReferenceObject referenceObjects() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().referenceObjects();
    }

    public CustomActivity withReferenceObjects(CustomActivityReferenceObject referenceObjects) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withReferenceObjects(referenceObjects);
        return this;
    }

    public Map<String, Object> extendedProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().extendedProperties();
    }

    public CustomActivity withExtendedProperties(Map<String, Object> extendedProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withExtendedProperties(extendedProperties);
        return this;
    }

    public Object retentionTimeInDays() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().retentionTimeInDays();
    }

    public CustomActivity withRetentionTimeInDays(Object retentionTimeInDays) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withRetentionTimeInDays(retentionTimeInDays);
        return this;
    }

    public Object autoUserSpecification() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().autoUserSpecification();
    }

    public CustomActivity withAutoUserSpecification(Object autoUserSpecification) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CustomActivityTypeProperties();
        }
        this.innerTypeProperties().withAutoUserSpecification(autoUserSpecification);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model CustomActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CustomActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CustomActivity fromJson(JsonReader jsonReader) throws IOException {
        return (CustomActivity)jsonReader.readObject(reader -> {
            CustomActivity deserializedCustomActivity = new CustomActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCustomActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCustomActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedCustomActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedCustomActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedCustomActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedCustomActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedCustomActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedCustomActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedCustomActivity.innerTypeProperties = CustomActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCustomActivity.withAdditionalProperties(additionalProperties);
            return deserializedCustomActivity;
        });
    }
}

