/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.BlobEventsTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.BlobEventTypes;
import com.azure.resourcemanager.datafactory.models.MultiplePipelineTrigger;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.azure.resourcemanager.datafactory.models.TriggerRuntimeState;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class BlobEventsTrigger
extends MultiplePipelineTrigger {
    private String type = "BlobEventsTrigger";
    private BlobEventsTriggerTypeProperties innerTypeProperties = new BlobEventsTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(BlobEventsTrigger.class);

    @Override
    public String type() {
        return this.type;
    }

    BlobEventsTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public BlobEventsTrigger withPipelines(List<TriggerPipelineReference> pipelines) {
        super.withPipelines(pipelines);
        return this;
    }

    @Override
    public BlobEventsTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public BlobEventsTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations((List)annotations);
        return this;
    }

    public String blobPathBeginsWith() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().blobPathBeginsWith();
    }

    public BlobEventsTrigger withBlobPathBeginsWith(String blobPathBeginsWith) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withBlobPathBeginsWith(blobPathBeginsWith);
        return this;
    }

    public String blobPathEndsWith() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().blobPathEndsWith();
    }

    public BlobEventsTrigger withBlobPathEndsWith(String blobPathEndsWith) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withBlobPathEndsWith(blobPathEndsWith);
        return this;
    }

    public Boolean ignoreEmptyBlobs() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().ignoreEmptyBlobs();
    }

    public BlobEventsTrigger withIgnoreEmptyBlobs(Boolean ignoreEmptyBlobs) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withIgnoreEmptyBlobs(ignoreEmptyBlobs);
        return this;
    }

    public List<BlobEventTypes> events() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().events();
    }

    public BlobEventsTrigger withEvents(List<BlobEventTypes> events) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withEvents(events);
        return this;
    }

    public String scope() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scope();
    }

    public BlobEventsTrigger withScope(String scope) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withScope(scope);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model BlobEventsTrigger"));
        }
        this.innerTypeProperties().validate();
        if (this.pipelines() != null) {
            this.pipelines().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("pipelines", this.pipelines(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static BlobEventsTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (BlobEventsTrigger)jsonReader.readObject(reader -> {
            BlobEventsTrigger deserializedBlobEventsTrigger = new BlobEventsTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedBlobEventsTrigger.withDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedBlobEventsTrigger.withRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedBlobEventsTrigger.withAnnotations(annotations);
                    continue;
                }
                if ("pipelines".equals(fieldName)) {
                    List pipelines = reader.readArray(reader1 -> TriggerPipelineReference.fromJson(reader1));
                    deserializedBlobEventsTrigger.withPipelines(pipelines);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedBlobEventsTrigger.innerTypeProperties = BlobEventsTriggerTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobEventsTrigger.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedBlobEventsTrigger.withAdditionalProperties(additionalProperties);
            return deserializedBlobEventsTrigger;
        });
    }
}

