/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureSqlMILinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.AzureSqlMIAuthenticationType;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SqlAlwaysEncryptedProperties;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureSqlMILinkedService
extends LinkedService {
    private String type = "AzureSqlMI";
    private AzureSqlMILinkedServiceTypeProperties innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureSqlMILinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureSqlMILinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureSqlMILinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public AzureSqlMILinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureSqlMILinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureSqlMILinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureSqlMILinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public AzureSqlMILinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public AzureSqlMIAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public AzureSqlMILinkedService withAuthenticationType(AzureSqlMIAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public AzureSqlMILinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public AzureSqlMILinkedService withPassword(AzureKeyVaultSecretReference password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    public AzureSqlMILinkedService withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    public AzureSqlMILinkedService withServicePrincipalKey(SecretBase servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalCredentialType();
    }

    public AzureSqlMILinkedService withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalCredentialType(servicePrincipalCredentialType);
        return this;
    }

    public SecretBase servicePrincipalCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalCredential();
    }

    public AzureSqlMILinkedService withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalCredential(servicePrincipalCredential);
        return this;
    }

    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    public AzureSqlMILinkedService withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    public Object azureCloudType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().azureCloudType();
    }

    public AzureSqlMILinkedService withAzureCloudType(Object azureCloudType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAzureCloudType(azureCloudType);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AzureSqlMILinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public SqlAlwaysEncryptedProperties alwaysEncryptedSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().alwaysEncryptedSettings();
    }

    public AzureSqlMILinkedService withAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAlwaysEncryptedSettings(alwaysEncryptedSettings);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public AzureSqlMILinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public AzureSqlMILinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    public AzureSqlMILinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    public Object encrypt() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encrypt();
    }

    public AzureSqlMILinkedService withEncrypt(Object encrypt) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncrypt(encrypt);
        return this;
    }

    public Object trustServerCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustServerCertificate();
    }

    public AzureSqlMILinkedService withTrustServerCertificate(Object trustServerCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    public Object hostnameInCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().hostnameInCertificate();
    }

    public AzureSqlMILinkedService withHostnameInCertificate(Object hostnameInCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHostnameInCertificate(hostnameInCertificate);
        return this;
    }

    public Object applicationIntent() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().applicationIntent();
    }

    public AzureSqlMILinkedService withApplicationIntent(Object applicationIntent) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withApplicationIntent(applicationIntent);
        return this;
    }

    public Object connectTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectTimeout();
    }

    public AzureSqlMILinkedService withConnectTimeout(Object connectTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectTimeout(connectTimeout);
        return this;
    }

    public Object connectRetryCount() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectRetryCount();
    }

    public AzureSqlMILinkedService withConnectRetryCount(Object connectRetryCount) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectRetryCount(connectRetryCount);
        return this;
    }

    public Object connectRetryInterval() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectRetryInterval();
    }

    public AzureSqlMILinkedService withConnectRetryInterval(Object connectRetryInterval) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectRetryInterval(connectRetryInterval);
        return this;
    }

    public Object loadBalanceTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().loadBalanceTimeout();
    }

    public AzureSqlMILinkedService withLoadBalanceTimeout(Object loadBalanceTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    public Object commandTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandTimeout();
    }

    public AzureSqlMILinkedService withCommandTimeout(Object commandTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCommandTimeout(commandTimeout);
        return this;
    }

    public Object integratedSecurity() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().integratedSecurity();
    }

    public AzureSqlMILinkedService withIntegratedSecurity(Object integratedSecurity) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withIntegratedSecurity(integratedSecurity);
        return this;
    }

    public Object failoverPartner() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().failoverPartner();
    }

    public AzureSqlMILinkedService withFailoverPartner(Object failoverPartner) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFailoverPartner(failoverPartner);
        return this;
    }

    public Object maxPoolSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().maxPoolSize();
    }

    public AzureSqlMILinkedService withMaxPoolSize(Object maxPoolSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMaxPoolSize(maxPoolSize);
        return this;
    }

    public Object minPoolSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().minPoolSize();
    }

    public AzureSqlMILinkedService withMinPoolSize(Object minPoolSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMinPoolSize(minPoolSize);
        return this;
    }

    public Object multipleActiveResultSets() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().multipleActiveResultSets();
    }

    public AzureSqlMILinkedService withMultipleActiveResultSets(Object multipleActiveResultSets) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    public Object multiSubnetFailover() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().multiSubnetFailover();
    }

    public AzureSqlMILinkedService withMultiSubnetFailover(Object multiSubnetFailover) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    public Object packetSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packetSize();
    }

    public AzureSqlMILinkedService withPacketSize(Object packetSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPacketSize(packetSize);
        return this;
    }

    public Object pooling() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pooling();
    }

    public AzureSqlMILinkedService withPooling(Object pooling) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlMILinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPooling(pooling);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureSqlMILinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlMILinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlMILinkedService)jsonReader.readObject(reader -> {
            AzureSqlMILinkedService deserializedAzureSqlMILinkedService = new AzureSqlMILinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureSqlMILinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureSqlMILinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureSqlMILinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureSqlMILinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureSqlMILinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureSqlMILinkedService.innerTypeProperties = AzureSqlMILinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureSqlMILinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureSqlMILinkedService.withAdditionalProperties(additionalProperties);
            return deserializedAzureSqlMILinkedService;
        });
    }
}

